/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.dolphindb.jdbc.Driver;
import com.dolphindb.jdbc.JDBCConnection;
import com.dolphindb.jdbc.JDBCResultSet;
import com.dolphindb.jdbc.JDBCStatement;
import com.dolphindb.jdbc.TypeCast;
import com.dolphindb.jdbc.Utils;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicMonth;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class JDBCPrepareStatement
extends JDBCStatement
implements PreparedStatement {
    private String tableName;
    private Entity tableNameArg;
    private String preSql;
    private String[] sqlSplit;
    private Object[] values;
    private int dml;
    private Object arguments;
    private List<Object> argumentsBatch;
    private boolean isInsert;
    private String tableType;
    private List<String> colNames;
    private List<Entity.DATA_TYPE> colTypes_;
    private int tableRows = 0;
    private HashMap<String, ArrayList> unNameTable;

    public String getTableName() {
        return this.tableName;
    }

    public JDBCPrepareStatement(JDBCConnection connection, String sql) throws SQLException {
        super(connection);
        sql = Utils.changeCase(sql);
        this.connection = connection;
        this.preSql = sql.trim();
        while (this.preSql.endsWith(";")) {
            this.preSql = this.preSql.substring(0, this.preSql.length() - 1);
        }
        if ((sql = sql.trim()) != null && sql.equals("select 1")) {
            sql = "select 1 as val";
        }
        String[] strings = this.preSql.split(";");
        String lastStatement = strings[strings.length - 1].trim();
        this.tableName = Utils.getTableName(lastStatement);
        this.dml = Utils.getDml(lastStatement);
        boolean bl = this.isInsert = this.dml == 1;
        if (this.tableName != null) {
            this.tableName = this.tableName.trim();
            switch (this.dml) {
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    if (this.tableName.length() > 0) {
                        this.tableNameArg = new BasicString(this.tableName);
                        if (this.tableTypes != null) break;
                        this.tableTypes = new LinkedHashMap();
                        break;
                    }
                    throw new SQLException("check the SQl " + this.preSql);
                }
            }
        }
        this.preSql = this.preSql + ";";
        this.sqlSplit = this.preSql.split("\\?");
        this.values = new Object[this.sqlSplit.length + 1];
        this.batch = new StringBuilder();
    }

    private void getTableType() {
        if (this.tableType == null) {
            try {
                this.tableType = this.connection.run("typestr " + this.tableName).getString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.tableType != null) {
                if (this.tableTypes == null) {
                    this.tableTypes = new LinkedHashMap();
                }
                this.tableTypes.put(this.tableName, this.tableType);
            }
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.createSql());
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.arguments == null) {
            try {
                this.arguments = this.createArguments();
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
        }
        try {
            this.createArguments();
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        switch (this.dml) {
            case 1: {
                if (this.tableName != null) {
                    this.getTableType();
                    if (this.tableType.equals("IN-MEMORY TABLE")) {
                        try {
                            BasicInt basicInt = (BasicInt)this.connection.run("tableInsert", (List)this.arguments);
                            return basicInt.getInt();
                        }
                        catch (IOException e) {
                            throw new SQLException(e);
                        }
                    }
                    return this.tableAppend();
                }
                throw new SQLException("check the SQL " + this.preSql);
            }
            case 2: 
            case 3: {
                if (this.tableName != null) {
                    this.getTableType();
                    try {
                        return super.executeUpdate((String)this.arguments);
                    }
                    catch (SQLException e) {
                        throw new SQLException(e);
                    }
                }
                throw new SQLException("check the SQL " + this.preSql);
            }
            case 0: 
            case 4: {
                throw new SQLException("can not produces ResultSet");
            }
        }
        if (this.arguments instanceof String) {
            Entity entity;
            try {
                entity = this.connection.run((String)this.arguments);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            if (entity instanceof BasicTable) {
                throw new SQLException("can not produces ResultSet");
            }
        }
        return 0;
    }

    public int executeUpdate(Object arguments) throws SQLException {
        if (this.tableName != null) {
            this.getTableType();
            if (this.tableType.equals("IN-MEMORY TABLE")) {
                try {
                    BasicInt basicInt = (BasicInt)this.connection.run("tableInsert", (List)arguments);
                    return basicInt.getInt();
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
            }
            return this.tableAppend();
        }
        throw new SQLException("check the SQL " + this.preSql);
    }

    private int tableAppend() throws SQLException {
        if (this.unNameTable.size() > 1) {
            int insertRows = 0;
            ArrayList<Vector> cols = new ArrayList<Vector>(this.unNameTable.size());
            try {
                for (int i = 0; i < this.colNames.size(); ++i) {
                    Entity.DATA_TYPE dataType = this.colTypes_.get(i);
                    List values = this.unNameTable.get(this.colNames.get(i));
                    Vector col = BasicEntityFactory.instance().createVectorWithDefaultValue(dataType, 1);
                    col.set(0, (Scalar)values.get(this.tableRows));
                    cols.add(col);
                }
                ++this.tableRows;
            }
            catch (Exception e) {
                return 0;
            }
            if (this.tableRows == this.unNameTable.get(this.colNames.get(0)).size()) {
                this.unNameTable = null;
                this.tableRows = 0;
            }
            ArrayList<Entity> param = new ArrayList<Entity>();
            BasicTable insertTable = new BasicTable(this.colNames, cols);
            param.add((Entity)insertTable);
            try {
                this.connection.run("append!{" + this.tableName + "}", param);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            cols = null;
            insertTable = null;
            return insertRows;
        }
        return 0;
    }

    @Override
    public void setNull(int parameterIndex, int type) throws SQLException {
        if (this.colTypes_ == null) {
            try {
                BasicDictionary schema = (BasicDictionary)this.connection.run("schema(" + this.tableName + ")");
                BasicTable colDefs = (BasicTable)schema.get((Scalar)new BasicString("colDefs"));
                BasicIntVector colDefsTypeInt = (BasicIntVector)colDefs.getColumn("typeInt");
                int size = colDefs.rows();
                this.colTypes_ = new ArrayList<Entity.DATA_TYPE>();
                for (int i = 0; i < size; ++i) {
                    this.colTypes_.add(Entity.DATA_TYPE.valueOf((int)colDefsTypeInt.getInt(i)));
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                return;
            }
        }
        this.setObject(parameterIndex, TypeCast.nullScalar(this.colTypes_.get(parameterIndex - 1)));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setObject(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal bigDecimal) throws SQLException {
        this.setObject(parameterIndex, bigDecimal.doubleValue());
    }

    @Override
    public void setString(int parameterIndex, String s) throws SQLException {
        this.setObject(parameterIndex, s);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        this.setObject(parameterIndex, bytes);
    }

    @Override
    public void setDate(int parameterIndex, Date date) throws SQLException {
        this.setObject(parameterIndex, date);
    }

    @Override
    public void setTime(int parameterIndex, Time time) throws SQLException {
        this.setObject(parameterIndex, time);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp) throws SQLException {
        this.setObject(parameterIndex, timestamp);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        Driver.unused();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        Driver.unused();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        Driver.unused();
    }

    @Override
    public void clearParameters() throws SQLException {
        super.clearBatch();
        if (this.values != null) {
            int len = this.values.length;
            for (int i = 0; i < len; ++i) {
                this.values[i] = null;
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object object) throws SQLException {
        if (parameterIndex > this.sqlSplit.length - 1) {
            throw new SQLException(MessageFormat.format("Parameter index out of range ({0} > number of parameters, which is {1}).", parameterIndex, this.sqlSplit.length - 1));
        }
        this.values[parameterIndex] = object;
    }

    @Override
    public void setObject(int parameterIndex, Object object, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, object);
    }

    @Override
    public void setObject(int parameterIndex, Object object, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, object);
    }

    @Override
    public boolean execute() throws SQLException {
        switch (this.dml) {
            case 0: 
            case 4: {
                ResultSet resultSet_ = this.executeQuery();
                this.resultSets.offerLast(resultSet_);
                this.objectQueue.offer(resultSet_);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.objectQueue.offer(this.executeUpdate());
                break;
            }
            default: {
                Entity entity;
                String newSql;
                if (!(this.arguments instanceof String)) break;
                try {
                    newSql = (String)this.arguments;
                    entity = this.connection.run(newSql);
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
                if (!(entity instanceof BasicTable)) break;
                JDBCResultSet resultSet_ = new JDBCResultSet(this.connection, (JDBCStatement)this, entity, newSql);
                this.resultSets.offerLast(resultSet_);
                this.objectQueue.offer(resultSet_);
            }
        }
        if (this.objectQueue.isEmpty()) {
            return false;
        }
        this.result = this.objectQueue.poll();
        return this.result instanceof ResultSet;
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.argumentsBatch == null) {
            this.argumentsBatch = new ArrayList<Object>();
        }
        try {
            this.arguments = this.createArguments();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        if (this.arguments != null) {
            this.argumentsBatch.add(this.arguments);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.argumentsBatch == null) {
            this.argumentsBatch = new ArrayList<Object>();
        }
        this.argumentsBatch.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        super.clearBatch();
        if (this.argumentsBatch != null) {
            this.argumentsBatch.clear();
        }
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.sqlSplit = null;
        this.values = null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] arr_int = new int[this.argumentsBatch.size()];
        int index = 0;
        try {
            for (Object args : this.argumentsBatch) {
                if (args == null) {
                    arr_int[index++] = 0;
                    continue;
                }
                if (args instanceof String) {
                    arr_int[index++] = super.executeUpdate((String)args);
                    continue;
                }
                arr_int[index++] = this.executeUpdate(args);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BatchUpdateException(e.getMessage(), Arrays.copyOf(arr_int, index));
        }
        return arr_int;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        Driver.unused("setCharacterStream not implemented");
    }

    @Override
    public void setRef(int parameterIndex, Ref ref) throws SQLException {
        Driver.unused("setRef not implemented");
    }

    @Override
    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        byte[] blobbyte = blob.getBytes(1L, (int)blob.length());
        String blobstring = new String(blobbyte);
        this.setObject(parameterIndex, blobstring);
    }

    @Override
    public void setClob(int parameterIndex, Clob clob) throws SQLException {
        Driver.unused("setClob not implemented");
    }

    @Override
    public void setArray(int parameterIndex, Array array) throws SQLException {
        Driver.unused("setArray not implemented");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.resultSet != null) {
            return this.resultSet.getMetaData();
        }
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date date, Calendar cal) throws SQLException {
        this.setObject(parameterIndex, date);
    }

    @Override
    public void setTime(int parameterIndex, Time time, Calendar cal) throws SQLException {
        this.setObject(parameterIndex, time);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp, Calendar cal) throws SQLException {
        this.setObject(parameterIndex, timestamp);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        Driver.unused("setNull not implemented");
    }

    @Override
    public void setURL(int parameterIndex, URL url) throws SQLException {
        Driver.unused("setURL not implemented");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        Driver.unused("getParameterMetaData not implemented");
        return null;
    }

    @Override
    public void setRowId(int parameterIndex, RowId rowId) throws SQLException {
        Driver.unused("setRowId not implemented");
    }

    @Override
    public void setNString(int parameterIndex, String s) throws SQLException {
        this.setObject(parameterIndex, s);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader, long l) throws SQLException {
        Driver.unused("setNCharacterStream not implemented");
    }

    @Override
    public void setNClob(int parameterIndex, NClob nClob) throws SQLException {
        Driver.unused("setNClob not implemented");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long l) throws SQLException {
        Driver.unused("setClob not implemented");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long l) throws SQLException {
        Driver.unused("setBlob not implemented");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long l) throws SQLException {
        Driver.unused("setNClob not implemented");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML sqlxml) throws SQLException {
        Driver.unused("setSQLXML not implemented");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, long l) throws SQLException {
        Driver.unused("setAsciiStream not implemented");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, long l) throws SQLException {
        Driver.unused("setBinaryStream not implemented");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long l) throws SQLException {
        Driver.unused("setCharacterStream not implemented");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream) throws SQLException {
        Driver.unused("setAsciiStream not implemented");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream) throws SQLException {
        Driver.unused("setBinaryStream not implemented");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        Driver.unused("setCharacterStream not implemented");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        Driver.unused("setNCharacterStream not implemented");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        Driver.unused("setClob not implemented");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        Driver.unused("setBlob not implemented");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        Driver.unused("setNClob not implemented");
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        Driver.unused("setObject not implemented");
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        Driver.unused("setObject not implemented");
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return 0L;
    }

    private Object createArguments() throws IOException {
        if (this.isInsert) {
            int i;
            int size;
            BasicTable colDefs;
            BasicDictionary schema;
            if (this.colNames == null) {
                schema = (BasicDictionary)this.connection.run("schema(" + this.tableName + ")");
                colDefs = (BasicTable)schema.get((Scalar)new BasicString("colDefs"));
                BasicStringVector names = (BasicStringVector)colDefs.getColumn("name");
                size = names.rows();
                this.colNames = new ArrayList<String>();
                for (i = 0; i < size; ++i) {
                    this.colNames.add(names.getString(i).toString());
                }
            }
            if (this.colTypes_ == null) {
                schema = (BasicDictionary)this.connection.run("schema(" + this.tableName + ")");
                colDefs = (BasicTable)schema.get((Scalar)new BasicString("colDefs"));
                BasicIntVector colDefsTypeInt = (BasicIntVector)colDefs.getColumn("typeInt");
                size = colDefs.rows();
                this.colTypes_ = new ArrayList<Entity.DATA_TYPE>();
                for (i = 0; i < size; ++i) {
                    this.colTypes_.add(Entity.DATA_TYPE.valueOf((int)colDefsTypeInt.getInt(i)));
                }
            }
            try {
                ArrayList<Entity> arguments = new ArrayList<Entity>(this.sqlSplit.length);
                arguments.add(this.tableNameArg);
                this.getTableType();
                if (this.unNameTable == null) {
                    this.unNameTable = new LinkedHashMap<String, ArrayList>();
                }
                int j = 0;
                for (int i2 = 1; i2 < this.sqlSplit.length; ++i2) {
                    Entity.DATA_TYPE dataType = this.colTypes_.get(j);
                    if (this.values[i2] instanceof YearMonth) {
                        this.values[i2] = new BasicMonth(((YearMonth)this.values[i2]).getYear(), ((YearMonth)this.values[i2]).getMonth());
                    }
                    Entity entity = BasicEntityFactory.createScalar((Entity.DATA_TYPE)dataType, (Object)this.values[i2]);
                    if (!this.tableType.equals("IN-MEMORY TABLE")) {
                        if (this.unNameTable.size() == this.colTypes_.size()) {
                            ArrayList colValues = this.unNameTable.get(this.colNames.get(j));
                            colValues.add(entity);
                            this.unNameTable.put(this.colNames.get(j), colValues);
                        } else {
                            ArrayList<Entity> args = new ArrayList<Entity>();
                            args.add(entity);
                            this.unNameTable.put(this.colNames.get(j), args);
                        }
                    } else {
                        arguments.add(entity);
                    }
                    ++j;
                }
                return arguments;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            return this.createSql();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    private String createSql() throws SQLException {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < this.sqlSplit.length; ++i) {
            if (this.values[i] == null) {
                throw new SQLException("No value specified for parameter " + i);
            }
            String s = TypeCast.castDbString(this.values[i]);
            if (s == null) {
                return null;
            }
            sb.append(this.sqlSplit[i - 1]).append(s);
        }
        sb.append(this.sqlSplit[this.sqlSplit.length - 1]);
        return sb.toString();
    }
}

