/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.dolphindb.jdbc.Driver;
import com.dolphindb.jdbc.JDBCConnection;
import com.dolphindb.jdbc.JDBCResultSetMetaData;
import com.dolphindb.jdbc.JDBCStatement;
import com.dolphindb.jdbc.Utils;
import com.xxdb.data.BasicDate;
import com.xxdb.data.BasicDateTime;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicMinute;
import com.xxdb.data.BasicMonth;
import com.xxdb.data.BasicNanoTime;
import com.xxdb.data.BasicNanoTimestamp;
import com.xxdb.data.BasicSecond;
import com.xxdb.data.BasicTable;
import com.xxdb.data.BasicTime;
import com.xxdb.data.BasicTimestamp;
import com.xxdb.data.Entity;
import com.xxdb.data.EntityBlockReader;
import com.xxdb.data.Scalar;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;

public class JDBCResultSet
implements ResultSet {
    private JDBCConnection conn;
    private JDBCStatement statement;
    private BasicTable table;
    private int row = -1;
    private int rows;
    private String tableName;
    private Entity tableNameArg;
    private List<Entity> arguments;
    private HashMap<String, Integer> findColumnHashMap;
    private int updateRow;
    private int insertRow;
    private HashMap<Integer, Entity> insertRowMap;
    private boolean isInsert;
    private boolean isClosed = false;
    private boolean isUpdatable = false;
    private Object o;
    private Entity entity;
    private EntityBlockReader reader;

    public JDBCResultSet(JDBCConnection conn, JDBCStatement statement, Entity entity, String sql) throws SQLException {
        this.conn = conn;
        this.statement = statement;
        if (entity.isTable()) {
            this.table = (BasicTable)entity;
            this.rows = this.table.rows();
            this.findColumnHashMap = new HashMap(this.table.columns());
            for (int i = 0; i < this.table.columns(); ++i) {
                this.findColumnHashMap.put(this.table.getColumnName(i), i + 1);
            }
            this.isUpdatable = false;
            if (this.isUpdatable) {
                this.insertRowMap = new HashMap(this.table.columns() + 1);
            }
        } else {
            this.entity = entity;
            if (sql != null && sql.contains("select 1 as ")) {
                ArrayList<String> colNames = new ArrayList<String>(1);
                colNames.add(Utils.getSelectOneColName(sql));
                ArrayList<BasicIntVector> cols = new ArrayList<BasicIntVector>(1);
                BasicIntVector vector = new BasicIntVector(1);
                BasicInt scalar = new BasicInt(1);
                try {
                    vector.set(0, (Scalar)scalar);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                cols.add(vector);
                this.table = new BasicTable(colNames, cols);
                this.rows = this.table.rows();
                this.findColumnHashMap = new HashMap(this.table.columns());
                for (int i = 0; i < this.table.columns(); ++i) {
                    this.findColumnHashMap.put(this.table.getColumnName(i), i + 1);
                }
                this.isUpdatable = false;
                if (this.isUpdatable) {
                    this.insertRowMap = new HashMap(this.table.columns() + 1);
                }
            }
        }
    }

    public JDBCResultSet(JDBCConnection conn, JDBCStatement statement, EntityBlockReader reader, String sql) throws SQLException {
        this.conn = conn;
        this.statement = statement;
        this.reader = reader;
        if (!reader.hasNext().booleanValue()) {
            throw new SQLException("ResultSet data is null");
        }
        BasicTable entity = null;
        try {
            entity = (BasicTable)reader.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!entity.isTable()) {
            throw new SQLException("ResultSet data is null");
        }
        this.table = entity;
        this.rows = this.table.rows();
        this.findColumnHashMap = new HashMap(this.table.columns());
        for (int i = 0; i < this.table.columns(); ++i) {
            this.findColumnHashMap.put(this.table.getColumnName(i), i + 1);
        }
        this.isUpdatable = false;
        if (this.isUpdatable) {
            this.insertRowMap = new HashMap(this.table.columns() + 1);
        }
    }

    private BasicTable loadTable() throws SQLException {
        return (BasicTable)this.run(this.tableName);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.getFetchSize() != 0 && (this.table == null || this.row >= this.rows - 1)) {
            try {
                if (!this.reader.hasNext().booleanValue()) {
                    return false;
                }
                this.table = (BasicTable)this.reader.read();
                this.rows = this.table.rows();
                this.row = -1;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.checkClosed();
        ++this.row;
        return this.row <= this.rows - 1;
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        if (this.findColumnHashMap != null) {
            this.findColumnHashMap.clear();
            this.findColumnHashMap = null;
        }
        if (this.insertRowMap != null) {
            this.insertRowMap.clear();
            this.insertRowMap = null;
        }
        if (this.arguments != null) {
            this.arguments.clear();
            this.arguments = null;
        }
        this.table = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return ((Scalar)this.o).isNull();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.o = this.table.getColumn(this.adjustColumnIndex(columnIndex)).get(this.row);
        return this.o;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return ((Entity)this.getObject(columnIndex)).getString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Scalar x = (Scalar)this.getObject(columnIndex);
        if (x.isNull()) {
            return false;
        }
        try {
            return x.getNumber().byteValue() != 0;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Scalar x = (Scalar)this.getObject(columnIndex);
        if (x.isNull()) {
            return 0;
        }
        try {
            return x.getNumber().byteValue();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Scalar x = (Scalar)this.getObject(columnIndex);
        if (x.isNull()) {
            return 0;
        }
        try {
            return x.getNumber().shortValue();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Scalar x = (Scalar)this.getObject(columnIndex);
        if (x.isNull()) {
            return 0;
        }
        try {
            return x.getNumber().intValue();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Scalar x = (Scalar)this.getObject(columnIndex);
        if (x.isNull()) {
            return 0L;
        }
        try {
            return x.getNumber().longValue();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Scalar x = (Scalar)this.getObject(columnIndex);
        if (x.isNull()) {
            return 0.0f;
        }
        try {
            return x.getNumber().floatValue();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Scalar x = (Scalar)this.getObject(columnIndex);
        if (x.isNull()) {
            return 0.0;
        }
        try {
            return x.getNumber().doubleValue();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return BigDecimal.valueOf(this.getDouble(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Driver.unused("getBigDecimal not implemented");
        return null;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Driver.unused("getBytes not implemented");
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        LocalDateTime dt;
        Scalar x = (Scalar)this.getObject(columnIndex);
        LocalDate localdate = null;
        if (x instanceof BasicDate) {
            localdate = ((BasicDate)x).getDate();
        } else if (x instanceof BasicMonth) {
            YearMonth dt2 = ((BasicMonth)x).getMonth();
            if (dt2 != null) {
                localdate = LocalDate.of(dt2.getYear(), dt2.getMonth(), 1);
            }
        } else if (x instanceof BasicDateTime) {
            LocalDateTime dt3 = ((BasicDateTime)x).getDateTime();
            if (dt3 != null) {
                localdate = LocalDate.of(dt3.getYear(), dt3.getMonth(), dt3.getDayOfMonth());
            }
        } else if (x instanceof BasicTimestamp) {
            LocalDateTime dt4 = ((BasicTimestamp)x).getTimestamp();
            if (dt4 != null) {
                localdate = LocalDate.of(dt4.getYear(), dt4.getMonth(), dt4.getDayOfMonth());
            }
        } else if (x instanceof BasicNanoTimestamp && (dt = ((BasicNanoTimestamp)x).getNanoTimestamp()) != null) {
            localdate = LocalDate.of(dt.getYear(), dt.getMonth(), dt.getDayOfMonth());
        }
        if (localdate == null) {
            return null;
        }
        return Date.valueOf(localdate);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        LocalDateTime dt;
        Scalar x = (Scalar)this.getObject(columnIndex);
        LocalTime time = null;
        if (x instanceof BasicMinute) {
            time = ((BasicMinute)x).getMinute();
        } else if (x instanceof BasicSecond) {
            time = ((BasicSecond)x).getSecond();
        } else if (x instanceof BasicTime) {
            time = ((BasicTime)x).getTime();
        } else if (x instanceof BasicDateTime) {
            LocalDateTime dt2 = ((BasicDateTime)x).getDateTime();
            if (dt2 != null) {
                time = LocalTime.of(dt2.getHour(), dt2.getMinute(), dt2.getSecond());
            }
        } else if (x instanceof BasicNanoTime) {
            time = ((BasicNanoTime)x).getNanoTime();
        } else if (x instanceof BasicTimestamp) {
            LocalDateTime dt3 = ((BasicTimestamp)x).getTimestamp();
            if (dt3 != null) {
                time = LocalTime.of(dt3.getHour(), dt3.getMinute(), dt3.getSecond());
            }
        } else if (x instanceof BasicNanoTimestamp && (dt = ((BasicNanoTimestamp)x).getNanoTimestamp()) != null) {
            time = LocalTime.of(dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getNano());
        }
        if (time == null) {
            return null;
        }
        return Time.valueOf(time);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Scalar scalar = (Scalar)this.getObject(columnIndex);
        LocalDateTime dateTime = null;
        if (scalar instanceof BasicDateTime) {
            dateTime = ((BasicDateTime)scalar).getDateTime();
        } else if (scalar instanceof BasicTimestamp) {
            dateTime = ((BasicTimestamp)scalar).getTimestamp();
        } else if (scalar instanceof BasicNanoTimestamp) {
            dateTime = ((BasicNanoTimestamp)scalar).getNanoTimestamp();
        }
        if (dateTime == null) {
            return null;
        }
        return Timestamp.valueOf(dateTime);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new JDBCResultSetMetaData(this.table);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> aClass) throws SQLException {
        return (T)this.getObject(columnIndex);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> aClass) throws SQLException {
        return (T)this.getObject(columnLabel);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int x = this.findColumnHashMap.get(columnLabel);
        return this.findColumnHashMap.get(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.row < 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.row >= this.rows;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.row == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.row == this.rows - 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.row = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.row = this.rows;
    }

    @Override
    public boolean first() throws SQLException {
        this.row = 0;
        return this.rows > 0;
    }

    @Override
    public boolean last() throws SQLException {
        this.row = this.rows - 1;
        return this.rows > 0;
    }

    @Override
    public int getRow() throws SQLException {
        return this.row + 1;
    }

    @Override
    public boolean absolute(int columnIndex) throws SQLException {
        this.row = columnIndex >= 0 ? columnIndex - 1 : this.rows + columnIndex;
        return this.row < this.rows;
    }

    @Override
    public boolean relative(int columnIndex) throws SQLException {
        this.row += columnIndex;
        return this.row >= 0 && this.row < this.rows;
    }

    @Override
    public boolean previous() throws SQLException {
        --this.row;
        return this.row >= 0;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement != null ? this.statement.getFetchSize() : 0;
    }

    @Override
    public int getType() throws SQLException {
        return 1005;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public EntityBlockReader getReader() {
        return this.reader;
    }

    public void setReader(EntityBlockReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.update(columnIndex, (Object)Float.valueOf(x));
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal bigDecimal) throws SQLException {
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] bytes) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateDate(int columnIndex, Date date) throws SQLException {
        this.update(columnIndex, (Object)date);
    }

    @Override
    public void updateTime(int columnIndex, Time time) throws SQLException {
        this.update(columnIndex, (Object)time);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp timestamp) throws SQLException {
        this.update(columnIndex, (Object)timestamp);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, int columnIndex1) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, int columnIndex1) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, int columnIndex1) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateObject(int columnIndex, Object o, int columnIndex1) throws SQLException {
        this.update(columnIndex, o);
    }

    @Override
    public void updateObject(int columnIndex, Object o) throws SQLException {
        this.update(columnIndex, o);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.update(columnLabel, (Object)Float.valueOf(x));
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal bigDecimal) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] bytes) throws SQLException {
        this.update(columnLabel, (Object)bytes);
    }

    @Override
    public void updateDate(String columnLabel, Date date) throws SQLException {
        this.update(columnLabel, (Object)date);
    }

    @Override
    public void updateTime(String columnLabel, Time time) throws SQLException {
        this.update(columnLabel, (Object)time);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp timestamp) throws SQLException {
        this.update(columnLabel, (Object)timestamp);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream, int columnIndex) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream, int columnIndex) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int columnIndex) throws SQLException {
        Driver.unused();
    }

    @Override
    public void updateObject(String columnLabel, Object o, int columnIndex) throws SQLException {
        this.update(columnLabel, o);
    }

    @Override
    public void updateObject(String columnLabel, Object o) throws SQLException {
        this.update(columnLabel, o);
    }

    @Override
    public void insertRow() throws SQLException {
        this.isUpdatable();
        try {
            if (this.insertRow == this.row) {
                this.createArguments();
                this.conn.run("tableInsert", this.arguments);
                this.table = this.loadTable();
                this.rows = this.table.rows();
            }
            this.arguments.clear();
            this.insertRowMap.clear();
            this.isInsert = false;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void updateRow() throws SQLException {
        this.isUpdatable();
        if (this.updateRow == this.row) {
            this.updateRun();
            this.table = this.loadTable();
            this.rows = this.table.rows();
        }
        this.insertRowMap.clear();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.isUpdatable();
        StringBuilder sb = new StringBuilder("delete from ").append(this.tableName).append(" where ");
        for (int i = 1; i <= this.table.columns(); ++i) {
            sb.append(this.getColumnName(i)).append(" = ").append(Utils.java2db(this.getObject(i))).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        String sql = sb.toString();
        this.run(sql);
        this.table = this.loadTable();
        this.rows = this.table.rows();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.isUpdatable();
        BasicTable newTable = this.loadTable();
        try {
            for (int i = 0; i < newTable.columns(); ++i) {
                this.table.getColumn(i).set(this.row, newTable.getColumn(i).get(this.row));
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.isUpdatable();
        if (this.isInsert) {
            throw new SQLException("cursor is on the insert row");
        }
        this.insertRowMap.clear();
        this.isInsert = false;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.isUpdatable();
        this.isInsert = true;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.isInsert = false;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        SerialBlob blob = new SerialBlob(this.getObject(columnIndex).toString().getBytes());
        return blob;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(String columnLabel, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(String columnLabel, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateRef(int columnIndex, Ref ref) throws SQLException {
    }

    @Override
    public void updateRef(String columnLabel, Ref ref) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, Blob blob) throws SQLException {
        this.update(columnIndex, (Object)blob);
    }

    @Override
    public void updateBlob(String columnLabel, Blob blob) throws SQLException {
        this.update(columnLabel, (Object)blob);
    }

    @Override
    public void updateClob(int columnIndex, Clob clob) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Clob clob) throws SQLException {
    }

    @Override
    public void updateArray(int columnIndex, Array array) throws SQLException {
    }

    @Override
    public void updateArray(String columnLabel, Array array) throws SQLException {
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateRowId(int columnIndex, RowId rowId) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId rowId) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void updateNString(int columnIndex, String columnLabel) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String columnLabel1) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML sqlxml) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML sqlxml) throws SQLException {
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        return aClass.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return aClass.isInstance(this);
    }

    public Entity getResult() throws SQLException {
        if (this.table == null) {
            return this.entity;
        }
        return this.table;
    }

    public BasicDate getBasicDate(String columnLabel) throws SQLException {
        return (BasicDate)this.getObject(columnLabel);
    }

    public BasicMonth getBasicMonth(String columnLabel) throws SQLException {
        return (BasicMonth)this.getObject(columnLabel);
    }

    public BasicTime getBasicTime(String columnLabel) throws SQLException {
        return (BasicTime)this.getObject(columnLabel);
    }

    public BasicMinute getBasicMinute(String columnLabel) throws SQLException {
        return (BasicMinute)this.getObject(columnLabel);
    }

    public BasicSecond getBasicSecond(String columnLabel) throws SQLException {
        return (BasicSecond)this.getObject(columnLabel);
    }

    public BasicDateTime getBasicDateTime(String columnLabel) throws SQLException {
        return (BasicDateTime)this.getObject(columnLabel);
    }

    public BasicNanoTime getBasicNanoTime(String columnLabel) throws SQLException {
        return (BasicNanoTime)this.getObject(columnLabel);
    }

    public BasicNanoTimestamp getBasicNanoTimestamp(String columnLabel) throws SQLException {
        return (BasicNanoTimestamp)this.getObject(columnLabel);
    }

    public BasicDate getBasicDate(int columnIndex) throws SQLException {
        return (BasicDate)this.getObject(columnIndex);
    }

    public BasicMonth getBasicMonth(int columnIndex) throws SQLException {
        return (BasicMonth)this.getObject(columnIndex);
    }

    public BasicTime getBasicTime(int columnIndex) throws SQLException {
        return (BasicTime)this.getObject(columnIndex);
    }

    public BasicMinute getBasicMinute(int columnIndex) throws SQLException {
        return (BasicMinute)this.getObject(columnIndex);
    }

    public BasicSecond getBasicSecond(int columnIndex) throws SQLException {
        return (BasicSecond)this.getObject(columnIndex);
    }

    public BasicDateTime getBasicDateTime(int columnIndex) throws SQLException {
        return (BasicDateTime)this.getObject(columnIndex);
    }

    public BasicNanoTime getBasicNanoTime(int columnIndex) throws SQLException {
        return (BasicNanoTime)this.getObject(columnIndex);
    }

    public BasicNanoTimestamp getBasicNanoTimestamp(int columnIndex) throws SQLException {
        return (BasicNanoTimestamp)this.getObject(columnIndex);
    }

    public BasicTable getTable() {
        return this.table;
    }

    private void update(String name, Object value) throws SQLException {
        this.update(this.findColumn(name), value);
    }

    private void update(int columnIndex, Object value) throws SQLException {
        this.isUpdatable();
        if (this.isInsert) {
            this.insertRow = this.row;
        } else {
            this.updateRow = this.row;
        }
        this.insert(columnIndex, value);
    }

    private void insert(int columnIndex, Object value) throws SQLException {
        try {
            Scalar targetEntity = this.table.getColumn(this.adjustColumnIndex(columnIndex)).get(this.row);
            Entity.DATA_TYPE dataType = targetEntity.getDataType();
            Entity entity = BasicEntityFactory.createScalar((Entity.DATA_TYPE)dataType, (Object)value);
            this.insertRowMap.put(columnIndex, entity);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private void updateRun() throws SQLException {
        StringBuilder sb = new StringBuilder();
        StringBuilder where = new StringBuilder(" where ");
        sb.append("update ").append(this.tableName).append(" set ");
        for (int i = 1; i <= this.table.columns(); ++i) {
            Entity value = this.insertRowMap.get(i);
            if (value != null) {
                sb.append(this.getColumnName(i)).append(" = ").append(Utils.java2db(value)).append(", ");
            }
            where.append(this.getColumnName(i)).append(" = ").append(Utils.java2db(this.table.getColumn(this.adjustColumnIndex(i)).get(this.row))).append(" ,");
        }
        sb.delete(sb.length() - 2, sb.length());
        where.delete(where.length() - 2, where.length());
        sb.append((CharSequence)where);
        String sql = sb.toString();
        this.run(sql);
    }

    private Entity run(String sql) throws SQLException {
        try {
            return this.conn.run(sql);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private String getColumnName(int columnIndex) {
        return this.table.getColumnName(this.adjustColumnIndex(columnIndex));
    }

    private int adjustColumnIndex(int columnIndex) {
        return columnIndex - 1;
    }

    private void checkClosed() throws SQLException {
        if (this.table == null && this.isClosed) {
            throw new SQLException("ResultSet is closed");
        }
    }

    public void isUpdatable() throws SQLException {
        if (!this.isUpdatable) {
            throw new SQLException("Updating the table of ResultSet is not currently supported");
        }
    }

    private void createArguments() {
        int col = this.table.columns();
        if (this.arguments == null) {
            this.arguments = new ArrayList<Entity>(col + 1);
        }
        this.arguments.add(this.tableNameArg);
        for (int i = 1; i <= col; ++i) {
            this.arguments.add(this.insertRowMap.get(i));
        }
    }
}

