/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicDate;
import com.xxdb.data.BasicFloat;
import com.xxdb.data.BasicMonth;
import com.xxdb.data.BasicShort;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.BasicTime;
import com.xxdb.data.BasicTimestamp;
import com.xxdb.data.Entity;
import com.xxdb.data.Vector;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static final int DML_OTHER = -1;
    public static final int DML_SELECT = 0;
    public static final int DML_INSERT = 1;
    public static final int DML_UPDATE = 2;
    public static final int DML_DELETE = 3;
    public static final int DML_EXEC = 4;
    public static final Pattern INSERT_PATTERN = Pattern.compile("insert\\sinto\\s[a-zA-Z]{1}[a-zA-Z\\d_]*\\svalues\\s*\\(.+\\)");
    public static final Pattern DELETE_PATTERN = Pattern.compile("delete\\sfrom\\s[a-zA-Z]{1}[a-zA-Z\\d_]*\\s(where\\s(.+=.+)+)?");
    public static final Pattern UPDATE_PATTERN = Pattern.compile("update\\s[a-zA-Z]{1}[a-zA-Z\\d_]*\\sset\\s(.+=.+)+(\\swhere\\s(.+=.+)+)?");
    public static final Pattern ASSIGN_PATTERN = Pattern.compile("[a-zA-Z]{1}[a-zA-Z\\d_]*[\\s]*=");
    public static Set<String> sqlWareHouse = new HashSet<String>();

    private static void createHashSet() {
        sqlWareHouse.add("select");
        sqlWareHouse.add("from");
        sqlWareHouse.add("where");
        sqlWareHouse.add("as");
        sqlWareHouse.add("last");
        sqlWareHouse.add("exec");
        sqlWareHouse.add("or");
        sqlWareHouse.add("and");
        sqlWareHouse.add("order");
        sqlWareHouse.add("group");
        sqlWareHouse.add("by");
        sqlWareHouse.add("interval");
        sqlWareHouse.add("cgroup");
        sqlWareHouse.add("having");
        sqlWareHouse.add("update");
        sqlWareHouse.add("set");
        sqlWareHouse.add("insert");
        sqlWareHouse.add("into");
        sqlWareHouse.add("values");
        sqlWareHouse.add("delete");
        sqlWareHouse.add("limit");
        sqlWareHouse.add("top");
        sqlWareHouse.add("map");
        sqlWareHouse.add("pivot");
        sqlWareHouse.add("partition");
        sqlWareHouse.add("sample");
    }

    public static Object java2db(Object o) {
        if (o instanceof BasicStringVector || o instanceof BasicAnyVector || o instanceof AbstractVector || o instanceof Vector) {
            String s = ((Vector)o).getString();
            if (((Vector)o).get(0) instanceof BasicString) {
                return Utils.dbVectorString(s);
            }
            return s;
        }
        if (o instanceof String || o instanceof BasicString) {
            return "\"" + o + "\"";
        }
        if (o instanceof Character) {
            return "'" + o + "'";
        }
        if (o instanceof Short || o instanceof BasicShort) {
            return o + "h";
        }
        if (o instanceof Float || o instanceof BasicFloat) {
            return o + "f";
        }
        if (o instanceof Date) {
            return new BasicDate(((Date)o).toLocalDate());
        }
        if (o instanceof Time) {
            return new BasicTime(((Time)o).toLocalTime());
        }
        if (o instanceof Timestamp) {
            return new BasicTimestamp(((Timestamp)o).toLocalDateTime());
        }
        if (o instanceof YearMonth) {
            return new BasicMonth((YearMonth)o);
        }
        return o;
    }

    public static String dbVectorString(String s) {
        String[] strings = s.substring(1, s.length() - 1).split(",");
        StringBuilder sb = new StringBuilder("(");
        for (String it : strings) {
            sb.append("`").append(it).append(",");
        }
        sb.delete(sb.length() - 1, sb.length());
        sb.append(")");
        return sb.toString();
    }

    public static void joinOrder(StringBuilder sb, String[] values, String join) {
        for (String item : values) {
            if (item == null || item.length() <= 0) break;
            sb.append(item).append(join);
        }
        sb.delete(sb.length() - join.length(), sb.length());
    }

    public static void parseProperties(String s, Properties prop, String split1, String split2) throws SQLException {
        String[] strings1 = s.split(split1);
        int index = 0;
        String[] var7 = strings1;
        int var8 = strings1.length;
        for (int var9 = 0; var9 < var8; ++var9) {
            String item = var7[var9];
            if (item.contains("tb_")) {
                int index1 = item.indexOf("_");
                int index2 = item.indexOf("=");
                int index3 = item.indexOf("+");
                String subString1 = item.substring(index1 + 1, index2);
                String subString2 = item.substring(index2 + 1, index3);
                String subString3 = item.substring(index3 + 1);
                prop.setProperty("script" + index, subString1 + "=loadTable(\"" + subString2 + "\",\"" + subString3 + "\")");
                ++index;
                continue;
            }
            if (item.length() <= 0) continue;
            String[] strings2 = item.split(split2);
            if (strings2.length != 2) {
                throw new SQLException(item + "     is error");
            }
            if (strings2[0].length() == 0) {
                throw new SQLException(item + "     is error");
            }
            prop.setProperty(strings2[0], strings2[1]);
        }
        prop.setProperty("length", String.valueOf(index));
    }

    public static String[] getProperties(Properties prop, String[] keys) {
        String[] properties = new String[keys.length];
        int index = 0;
        for (String key : keys) {
            properties[index] = prop.getProperty(key);
            ++index;
        }
        return properties;
    }

    private static boolean startsWith(String sentence, String key) {
        if (sentence.length() < key.length()) {
            return false;
        }
        String substr = sentence.substring(0, key.length());
        return substr.compareToIgnoreCase(key) == 0;
    }

    public static int getDml(String sql) {
        String sqlBackup = new String(sql);
        if (Utils.startsWith(sqlBackup, "select")) {
            return 0;
        }
        if (sqlBackup.startsWith("insert") || sqlBackup.startsWith("tableInsert")) {
            return 1;
        }
        if (sqlBackup.startsWith("update")) {
            return 2;
        }
        if (sqlBackup.startsWith("delete")) {
            return 3;
        }
        if (sqlBackup.startsWith("exec")) {
            return 4;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getTableName(String sql) throws SQLException {
        String tableName = null;
        if (sql.startsWith("insert")) {
            Matcher matcher = INSERT_PATTERN.matcher(sql);
            if (!matcher.find()) throw new SQLException("check the SQl " + sql);
            return sql.substring(sql.indexOf("into") + "into".length(), sql.indexOf("values"));
        }
        if (sql.startsWith("tableInsert")) {
            return sql.substring(sql.indexOf("(") + "(".length(), sql.indexOf(","));
        }
        if (sql.startsWith("append!")) {
            return sql.substring(sql.indexOf("(") + "(".length(), sql.indexOf(","));
        }
        if (sql.contains(".append!")) {
            return sql.split("\\.")[0];
        }
        if (sql.startsWith("update")) {
            Matcher matcher = UPDATE_PATTERN.matcher(sql);
            if (!matcher.find()) throw new SQLException("check the SQl " + sql);
            return sql.substring(sql.indexOf("update") + "update".length(), sql.indexOf("set"));
        }
        if (sql.contains(".update!")) {
            return sql.split("\\.")[0];
        }
        if (!sql.startsWith("delete")) return tableName;
        Matcher matcher = DELETE_PATTERN.matcher(sql);
        if (!matcher.find()) throw new SQLException("check the SQl " + sql);
        int index = sql.indexOf("where");
        if (index == -1) return sql.substring(sql.indexOf("from") + "from".length()).replaceAll(";", "");
        return sql.substring(sql.indexOf("from") + "from".length(), sql.indexOf("where"));
    }

    public static boolean isUpdateable(String s) {
        String s1 = s.trim().split(";")[0];
        String regex = "full.*join|inner.*join|right.*join|left.*join|join.*(.*)|ej.*(.*)|sej.*(.*)|lj.*(.*)|fj.*(.*)|aj.*(.*)|cj.*(.*)|group.*by|context.*by|pivot.*by";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(s1);
        return !matcher.find();
    }

    public static String getRandomString(int length) {
        String character = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String base = character + "0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        int number = random.nextInt(character.length());
        sb.append(character.charAt(number));
        for (int i = 1; i < length; ++i) {
            number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static BasicTable Vevtor2Table(Vector vector, String sql) {
        ArrayList<String> colNames = new ArrayList<String>(1);
        if ((sql = sql.trim()).contains("as")) {
            colNames.add(sql.split(" ")[3]);
        } else {
            colNames.add(sql.split(" ")[1]);
        }
        ArrayList<Vector> cols = new ArrayList<Vector>(1);
        cols.add(vector);
        return new BasicTable(colNames, cols);
    }

    public static String changeCase(String sql) {
        if (sql == null) {
            return sql;
        }
        Utils.createHashSet();
        StringBuilder sbSql = new StringBuilder();
        StringBuilder sbKey1 = new StringBuilder();
        char chr = '\u0000';
        for (int i = 0; i < sql.length(); ++i) {
            String lowerKey;
            String key;
            chr = sql.charAt(i);
            if (chr >= 'a' && chr <= 'z' || chr >= 'A' && chr <= 'Z' || chr >= '0' && chr <= '9') {
                sbKey1.append(chr);
            } else {
                if (sbKey1.length() > 0) {
                    key = sbKey1.toString();
                    lowerKey = key.toLowerCase();
                    if (sqlWareHouse.contains(lowerKey)) {
                        sbSql.append(lowerKey);
                    } else {
                        sbSql.append(key);
                    }
                }
                sbSql.append(chr);
                sbKey1.delete(0, sbKey1.length());
            }
            if (i != sql.length() - 1 || sbKey1.length() <= 0) continue;
            key = sbKey1.toString();
            lowerKey = key.toLowerCase();
            if (sqlWareHouse.contains(lowerKey)) {
                sbSql.append(lowerKey);
                continue;
            }
            sbSql.append(key);
        }
        return sbSql.toString();
    }

    public static String getSelectOneColName(String sql) {
        String colName = sql.substring(sql.indexOf(" as ") + " as ".length());
        return colName;
    }

    public static String VectorToString(Entity entity) {
        String result = "";
        if (entity instanceof AbstractVector) {
            int length = ((Vector)entity).rows();
            for (int i = 0; i < length; ++i) {
                String s = String.valueOf(((Vector)entity).get(i));
                result = result + s + " ";
            }
        }
        return result;
    }
}

