/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.dolphindb.jdbc.Driver;
import com.dolphindb.jdbc.JDBCConnection;
import com.dolphindb.jdbc.JDBCResultSet;
import com.dolphindb.jdbc.JDBCStatement;
import com.dolphindb.jdbc.Utils;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicBoolean;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class JDBCDataBaseMetaData
implements DatabaseMetaData {
    private static final String DATABASE_NAME = "DolphinDB";
    private static final String DRIVER_NAME = "DolphinDB JDBC Driver";
    private static final String DRIVER_VERSION = "dolphindb-connector-java-2.0";
    private static final String DATABASE = "database";
    private final JDBCConnection connection;
    private final JDBCStatement statement;
    private static ResultSet TypeInfo;
    private static ResultSet Catalogs;
    private static ResultSet Schemas;

    public JDBCDataBaseMetaData(JDBCConnection connection, JDBCStatement statement) {
        this.connection = connection;
        this.statement = statement;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) {
        return null;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) {
        return null;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        ArrayList<String> colNames = new ArrayList<String>(Collections.singletonList("TABLE_CAT"));
        ArrayList<BasicStringVector> cols = new ArrayList<BasicStringVector>();
        try {
            BasicStringVector allCatalogStringVector = (BasicStringVector)this.connection.run("getAllCatalogs()");
            cols.add(allCatalogStringVector);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Catalogs = new JDBCResultSet(this.connection, this.statement, (Entity)new BasicTable(colNames, cols), "");
        return Catalogs;
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public String getCatalogTerm() {
        return DATABASE;
    }

    @Override
    public ResultSet getClientInfoProperties() {
        return null;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) {
        return null;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (!Utils.checkServerVersionIfSupportCatalog(this.connection)) {
            return null;
        }
        Map<String, Object> originMetaData = this.getColumnsOriginMetaData(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        BasicTable colDefs = this.assembleColumnsMetaData(originMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        return new JDBCResultSet(this.connection, this.statement, (Entity)colDefs, "");
    }

    private Map<String, Object> getColumnsOriginMetaData(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        HashMap<String, Object> originMetaData = new HashMap<String, Object>();
        ArrayList<BasicTable> tables = new ArrayList<BasicTable>();
        if (Utils.isNotEmpty(catalog) && !catalog.equals("%") && Utils.isNotEmpty(schemaPattern) && !schemaPattern.equals("%") && Utils.isNotEmpty(tableNamePattern) && Utils.isNotEmpty(columnNamePattern) && columnNamePattern.equals("%")) {
            try {
                if (!((BasicBoolean)this.connection.run("existsCatalog(\"" + catalog + "\")")).getBoolean()) {
                    throw new RuntimeException("The catalog '" + catalog + "' doesn't exist.");
                }
                BasicTable schemas = (BasicTable)this.connection.run("getSchemaByCatalog(\"" + catalog + "\")");
                if (schemas.rows() != 0) {
                    int pos = -1;
                    BasicStringVector schemaVector = (BasicStringVector)schemas.getColumn("schema");
                    for (int i = 0; i < schemas.rows(); ++i) {
                        if (!schemaVector.getString(i).equals(schemaPattern)) continue;
                        pos = i;
                    }
                    if (pos != -1) {
                        BasicStringVector dbUrlVector = (BasicStringVector)schemas.getColumn("dbUrl");
                        String dbUrl = dbUrlVector.getString(pos);
                        originMetaData.put("dbUrl", dbUrl);
                        if (tableNamePattern.trim().equals("%")) {
                            String script = "handle=database(\"" + dbUrl + "\"); getTables(handle);";
                            AbstractVector tableNameVec = (AbstractVector)this.connection.run(script);
                            for (int i = 0; i < tableNameVec.rows(); ++i) {
                                String tmpTableName = tableNameVec.getString(i);
                                String tableScript = "handle=loadTable(\"" + dbUrl + "\", `" + tmpTableName + "); schema(handle);";
                                BasicDictionary schema = (BasicDictionary)this.connection.run(tableScript);
                                tables.add((BasicTable)schema.get((Scalar)new BasicString("colDefs")));
                            }
                            originMetaData.put("tableNameVec", tableNameVec);
                        }
                        String script = "handle=loadTable(\"" + dbUrl + "\", `" + tableNamePattern + "); schema(handle);";
                        BasicDictionary schema = (BasicDictionary)this.connection.run(script);
                        tables.add((BasicTable)schema.get((Scalar)new BasicString("colDefs")));
                    }
                    throw new RuntimeException("schema" + schemaPattern + "doesn't exist in " + catalog + ".");
                }
                throw new RuntimeException("Current catalog '" + catalog + "' doesn't has any schema.");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (Utils.isEmpty(catalog) && Utils.isEmpty(schemaPattern) && Utils.isNotEmpty(tableNamePattern) && !tableNamePattern.equals("%")) {
            BasicDictionary schema = null;
            try {
                schema = (BasicDictionary)this.connection.run("schema(" + tableNamePattern + ");");
                tables.add((BasicTable)schema.get((Scalar)new BasicString("colDefs")));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        originMetaData.put("tables", tables);
        return originMetaData;
    }

    /*
     * Unable to fully structure code
     */
    private BasicTable assembleColumnsMetaData(Map<String, Object> originMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        colDefs = null;
        tables = (List)originMetaData.get("tables");
        dbUrl = (String)originMetaData.get("dbUrl");
        for (i = 0; i < tables.size(); ++i) {
            columnIndexList = new ArrayList<String>();
            try {
                if (Objects.nonNull(tableNamePattern) && !tableNamePattern.trim().equals("%")) {
                    tbName = tableNamePattern;
                } else {
                    tableNameVec = (AbstractVector)originMetaData.get("tableNameVec");
                    tableNameEn = tableNameVec.get(i);
                    tbName = tableNameEn.getString();
                }
                if (Objects.nonNull(catalog) && !catalog.isEmpty()) {
                    script = "handle=loadTable(\"" + dbUrl + "\", `" + tbName + "); schema(handle);";
                    schema = (BasicDictionary)this.connection.run(script);
                } else {
                    schema = (BasicDictionary)this.connection.run("schema(" + tbName + ");");
                }
                columnNameEntity = schema.get("partitionColumnName");
                if (Objects.nonNull(columnNameEntity)) {
                    if (columnNameEntity.isScalar()) {
                        columnName = (BasicString)columnNameEntity;
                        columnIndexList.add(columnName.getString());
                    } else if (columnNameEntity.isVector() && (columnNameVec = (AbstractVector)columnNameEntity) instanceof BasicStringVector) {
                        columnIndexList.addAll(Arrays.asList(((BasicStringVector)columnNameVec).getdataArray()));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            curTable = (BasicTable)tables.get(i);
            schemaAndTableColNames = new ArrayList<String>();
            schemaAndTableCols = new ArrayList<BasicStringVector>();
            schemaAndTableColNames.add("TABLE_CAT");
            schemaAndTableColNames.add("TABLE_SCHEM");
            schemaAndTableColNames.add("TABLE_NAME");
            if (Objects.nonNull(catalog) && !catalog.trim().equals("%")) {
                catalogNameList = new ArrayList<String>(Collections.nCopies(curTable.rows(), catalog));
                catalogNameVector = new BasicStringVector(catalogNameList);
                schemaAndTableCols.add(catalogNameVector);
            }
            if (Objects.nonNull(schemaPattern) && !schemaPattern.trim().equals("%")) {
                schemaNameList = new ArrayList<String>(Collections.nCopies(curTable.rows(), schemaPattern));
                schemaNameVector = new BasicStringVector(schemaNameList);
                schemaAndTableCols.add(schemaNameVector);
            }
            if (Objects.nonNull(tableNamePattern) && !tableNamePattern.trim().equals("%")) {
                tableNameList = new ArrayList<String>(Collections.nCopies(curTable.rows(), tableNamePattern));
                tableNameVector = new BasicStringVector(tableNameList);
                schemaAndTableCols.add(tableNameVector);
            } else {
                tableNameVec = (AbstractVector)originMetaData.get("tableNameVec");
                tableNameEn = tableNameVec.get(i);
                tableNameList = new ArrayList<String>(Collections.nCopies(curTable.rows(), tableNameEn.getString()));
                tableNameVector = new BasicStringVector(tableNameList);
                schemaAndTableCols.add(tableNameVector);
            }
            schemaAndTable = new BasicTable(schemaAndTableColNames, schemaAndTableCols);
            newColumnNames = new ArrayList<String>();
            newColumnNames.add("COLUMN_NAME");
            newColumnNames.add("TYPE_NAME");
            newColumnNames.add("DATA_TYPE");
            newColumnNames.add("EXTRA");
            newColumnNames.add("REMARKS");
            if (curTable.columns() == 6) {
                newColumnNames.add("sensitive");
            }
            curTable.setColName(newColumnNames);
            addColumnsNum = curTable.columns() == 6 ? curTable.columns() - 1 : curTable.columns();
            for (j = 0; j < addColumnsNum; ++j) {
                schemaAndTable.addColumn(curTable.getColumnName(j), curTable.getColumn(j));
            }
            curTable = schemaAndTable;
            try {
                typeStringColumn = (AbstractVector)curTable.getColumn(4);
                decimalDigits = new ArrayList<Integer>();
                for (j = 0; j < typeStringColumn.rows(); ++j) {
                    dataType = typeStringColumn.get(j).getString();
                    dataType = dataType.replaceAll("\\(.*?\\)", "");
                    curColDefs = (BasicTable)schema.get((Scalar)new BasicString("colDefs"));
                    extraVec = (BasicIntVector)curColDefs.getColumn("extra");
                    scale = -1;
                    var25_34 = dataType;
                    var26_36 = -1;
                    switch (var25_34.hashCode()) {
                        case -1156735664: {
                            if (!var25_34.equals("DECIMAL32")) break;
                            var26_36 = 0;
                            break;
                        }
                        case -1156735569: {
                            if (!var25_34.equals("DECIMAL64")) break;
                            var26_36 = 1;
                            break;
                        }
                        case -1499069082: {
                            if (!var25_34.equals("DECIMAL128")) break;
                            var26_36 = 2;
                        }
                    }
                    switch (var26_36) {
                        case 0: {
                            scale = extraVec.getInt(j);
                            break;
                        }
                        case 1: {
                            scale = extraVec.getInt(j);
                            break;
                        }
                        case 2: {
                            scale = extraVec.getInt(j);
                        }
                    }
                    decimalDigits.add(scale);
                }
                curTable.addColumn("DECIMAL_DIGITS", (Vector)new BasicIntVector(decimalDigits));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            isNullableStrList = new ArrayList<E>();
            nameColumn = (AbstractVector)curTable.getColumn(3);
            nameArr = null;
            if (nameColumn instanceof BasicStringVector) {
                nameArr = ((BasicStringVector)nameColumn).getdataArray();
                Arrays.stream(nameArr).map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$assembleColumnsMetaData$0(java.util.List java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)(columnIndexList)).forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Ljava/lang/String;)V)(isNullableStrList));
                curTable.addColumn("IS_NULLABLE", (Vector)new BasicStringVector(isNullableStrList));
            }
            autoIncrementList = new ArrayList<String>(Collections.nCopies(curTable.rows(), ""));
            autoIncrementVec = new BasicStringVector(autoIncrementList);
            curTable.addColumn("IS_AUTOINCREMENT", (Vector)autoIncrementVec);
            if (Objects.nonNull(columnNamePattern) && !columnNamePattern.isEmpty() && !columnNamePattern.equals("%")) {
                try {
                    script = null;
                    script = Objects.nonNull(catalog) != false && catalog.isEmpty() == false ? String.format("schema(loadTable(\"%s\", `%s)).colDefs;", new Object[]{dbUrl, tableNamePattern}) : String.format("schema(%s).colDefs;", new Object[]{tableNamePattern});
                    tempColDefs = (BasicTable)this.connection.run(script);
                    tempNameColumn = (AbstractVector)tempColDefs.getColumn(0);
                    nameColumnList = null;
                    if (!(tempNameColumn instanceof BasicStringVector)) ** GOTO lbl154
                    nameColumnList = Arrays.asList(((BasicStringVector)tempNameColumn).getdataArray());
                    pos = nameColumnList.indexOf(columnNamePattern);
                    ordinalPositionList = new ArrayList<Integer>();
                    ordinalPositionList.add(pos + 1);
                    curTable.addColumn("ORDINAL_POSITION", (Vector)new BasicIntVector(ordinalPositionList));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                posColVector = new BasicIntVector(IntStream.rangeClosed(1, curTable.getColumn(0).rows()).boxed().collect(Collectors.toList()));
                curTable.addColumn("ORDINAL_POSITION", (Vector)posColVector);
            }
lbl154:
            // 3 sources

            try {
                typeStringColumn = (AbstractVector)curTable.getColumn(4);
                typeIntColumn = (BasicIntVector)curTable.getColumn(5);
                for (j = 0; j < typeStringColumn.rows(); ++j) {
                    typeIntColumn.set(j, (Entity)new BasicInt(Utils.transferColDefsTypesToSqlTypes(typeStringColumn.get(j).getString())));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            typeStringColumn = (AbstractVector)curTable.getColumn(4);
            sqlDataTypesList = null;
            if (typeStringColumn instanceof BasicStringVector) {
                sqlDataTypesList = Arrays.stream(((BasicStringVector)typeStringColumn).getdataArray()).map((Function<String, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, transferColDefsTypesToSqlTypes(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Integer;)()).collect(Collectors.toList());
            }
            sqlDataTypesColumn = new BasicIntVector(sqlDataTypesList);
            curTable.addColumn("SQL_DATA_TYPES", (Vector)sqlDataTypesColumn);
            colDefs = i == 0 ? curTable : colDefs.combine(curTable);
        }
        return colDefs;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        return null;
    }

    @Override
    public int getDatabaseMajorVersion() {
        return 0;
    }

    @Override
    public int getDatabaseMinorVersion() {
        return 0;
    }

    @Override
    public String getDatabaseProductName() {
        return DATABASE_NAME;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return 2;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    public String getDriverVersion() {
        return DRIVER_VERSION;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) {
        return null;
    }

    @Override
    public String getExtraNameCharacters() {
        return "@";
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) {
        return null;
    }

    @Override
    public String getIdentifierQuoteString() {
        return " ";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) {
        return null;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) {
        return null;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 0;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 0;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getSQLStateType() {
        return 1;
    }

    @Override
    public long getMaxLogicalLobSize() {
        return 0L;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) {
        return null;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) {
        return null;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) {
        return null;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) {
        return null;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        return null;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        if (!Utils.checkServerVersionIfSupportCatalog(this.connection)) {
            return null;
        }
        List<String> colNames = Arrays.asList("TABLE_SCHEM", "TABLE_CATALOG");
        ArrayList<BasicStringVector> cols = new ArrayList<BasicStringVector>();
        BasicStringVector schemaVec = new BasicStringVector(0);
        BasicStringVector catalogVec = new BasicStringVector(0);
        try {
            BasicStringVector catalogsVec = (BasicStringVector)this.connection.run("getAllCatalogs();");
            if (catalogsVec.rows() != 0) {
                for (int i = 0; i < catalogsVec.rows(); ++i) {
                    String curCatalog = catalogsVec.getString(i);
                    BasicTable schemasMapTb = (BasicTable)this.connection.run("getSchemaByCatalog(\"" + curCatalog + "\");");
                    BasicStringVector curSchemaVec = (BasicStringVector)schemasMapTb.getColumn("schema");
                    schemaVec.Append((Vector)curSchemaVec);
                    catalogVec.Append((Vector)new BasicStringVector(new ArrayList<String>(Collections.nCopies(curSchemaVec.rows(), curCatalog))));
                }
                cols.add(schemaVec);
                cols.add(catalogVec);
                Schemas = new JDBCResultSet(this.connection, this.statement, (Entity)new BasicTable(colNames, cols), "");
            } else {
                Schemas = new JDBCResultSet(this.connection, this.statement, (Entity)null, "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Schemas;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (!Utils.checkServerVersionIfSupportCatalog(this.connection)) {
            return null;
        }
        List<String> colNames = Arrays.asList("TABLE_SCHEM", "TABLE_CATALOG");
        ArrayList<BasicStringVector> cols = new ArrayList<BasicStringVector>();
        BasicStringVector schemaVec = new BasicStringVector(0);
        BasicStringVector catalogVec = new BasicStringVector(0);
        if (Utils.isNotEmpty(catalog) && schemaPattern.equals("%")) {
            try {
                BasicTable schemasMapTb = (BasicTable)this.connection.run("getSchemaByCatalog(\"" + catalog + "\");");
                BasicStringVector curSchemaVec = (BasicStringVector)schemasMapTb.getColumn("schema");
                schemaVec.Append((Vector)curSchemaVec);
                catalogVec.Append((Vector)new BasicStringVector(new ArrayList<String>(Collections.nCopies(curSchemaVec.rows(), "\"" + catalog + "\""))));
                cols.add(schemaVec);
                cols.add(catalogVec);
                Schemas = new JDBCResultSet(this.connection, this.statement, (Entity)new BasicTable(colNames, cols), "");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Illegal param in getShemas");
        }
        return Schemas;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) {
        return null;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) {
        return null;
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (!Utils.checkServerVersionIfSupportCatalog(this.connection)) {
            return null;
        }
        ArrayList<String> colNames = new ArrayList<String>(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS"));
        ArrayList cols = new ArrayList();
        ArrayList<String> tableCatVal = new ArrayList<String>();
        ArrayList<String> tableSchemVal = new ArrayList<String>();
        ArrayList<String> tableNameVal = new ArrayList<String>();
        ArrayList<String> tableTypeVal = new ArrayList<String>();
        ArrayList<Object> remarksVal = new ArrayList<Object>();
        if (!Utils.isEmpty(catalog) && !catalog.trim().equals("%")) {
            if (Utils.isNotEmpty(schemaPattern) && !schemaPattern.trim().equals("%")) {
                try {
                    BasicTable schemas = (BasicTable)this.connection.run("getSchemaByCatalog(\"" + catalog + "\")");
                    if (schemas.rows() == 0) throw new RuntimeException("Current catalog " + catalog + " doesn't has any schema.");
                    int pos = -1;
                    BasicStringVector schemaVector = (BasicStringVector)schemas.getColumn("schema");
                    for (int i = 0; i < schemas.rows(); ++i) {
                        if (!schemaVector.getString(i).equals(schemaPattern)) continue;
                        pos = i;
                    }
                    if (pos == -1) throw new RuntimeException("schema" + schemaPattern + "doesn't exist in " + catalog + ".");
                    BasicStringVector dbUrlVector = (BasicStringVector)schemas.getColumn("dbUrl");
                    String dbUrl = dbUrlVector.getString(pos);
                    String script = "handle=database(\"" + dbUrl + "\"); getTables(handle);";
                    AbstractVector tableNameVec = (AbstractVector)this.connection.run(script);
                    for (int i = 0; i < tableNameVec.rows(); ++i) {
                        tableCatVal.add(catalog);
                        tableSchemVal.add(schemaPattern);
                        tableNameVal.add(tableNameVec.getString(i));
                        tableTypeVal.add("TABLE");
                        remarksVal.add(null);
                    }
                    Stream.of(tableCatVal, tableSchemVal, tableNameVal, tableTypeVal, remarksVal).map(BasicStringVector::new).forEach(cols::add);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else if (Objects.isNull(schemaPattern) || schemaPattern.trim().equals("%")) {
                try {
                    BasicTable schemas = (BasicTable)this.connection.run("getSchemaByCatalog(\"" + catalog + "\")");
                    if (schemas.rows() == 0) throw new RuntimeException("Current catalog " + catalog + " doesn't has any schema.");
                    BasicStringVector schemaVector = (BasicStringVector)schemas.getColumn("schema");
                    BasicStringVector dbUrlVector = (BasicStringVector)schemas.getColumn("dbUrl");
                    for (int i = 0; i < dbUrlVector.rows(); ++i) {
                        String dbUrl = dbUrlVector.getString(i);
                        String script = "handle=database(\"" + dbUrl + "\"); getTables(handle);";
                        AbstractVector tableNameVec = (AbstractVector)this.connection.run(script);
                        for (int j = 0; j < tableNameVec.rows(); ++j) {
                            tableCatVal.add(catalog);
                            tableSchemVal.add(schemaVector.getString(i));
                            tableNameVal.add(tableNameVec.getString(j));
                            tableTypeVal.add("TABLE");
                            remarksVal.add(null);
                        }
                    }
                    Stream.of(tableCatVal, tableSchemVal, tableNameVal, tableTypeVal, remarksVal).map(BasicStringVector::new).forEach(cols::add);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (Utils.isEmpty(catalog) && Utils.isEmpty(schemaPattern) && tableNamePattern.equals("%")) {
            try {
                AbstractVector form;
                BasicTable memTables = (BasicTable)this.connection.run("select * from objs(true) where form =\"TABLE\";");
                AbstractVector name = (AbstractVector)memTables.getColumn("name");
                if (Objects.nonNull(name)) {
                    for (int i = 0; i < name.rows(); ++i) {
                        BasicString memTableName = (BasicString)name.get(i);
                        tableCatVal.add(null);
                        tableSchemVal.add(null);
                        tableNameVal.add(memTableName.getString());
                        remarksVal.add(null);
                    }
                }
                if (Objects.nonNull(form = (AbstractVector)memTables.getColumn("form"))) {
                    for (int i = 0; i < form.rows(); ++i) {
                        BasicString memForm = (BasicString)form.get(i);
                        tableTypeVal.add(memForm.getString());
                    }
                }
                Stream.of(tableCatVal, tableSchemVal, tableNameVal, tableTypeVal, remarksVal).map(BasicStringVector::new).forEach(cols::add);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            if (!catalog.matches("%+")) throw new IllegalArgumentException("Invalid params in getTables.");
            throw new IllegalArgumentException("Invalid params in getTables, not support get all tables with no specific catalog and schema.");
        }
        BasicTable colDefs = new BasicTable(colNames, cols);
        return new JDBCResultSet(this.connection, this.statement, (Entity)colDefs, "");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        try {
            String[] tableTypes = new String[]{"IN-MEMORY TABLE", "SEGMENTED TABLE"};
            BasicStringVector basicStringVector = new BasicStringVector(tableTypes);
            List<String> colNames = Collections.singletonList("TABLE_TYPE");
            List<BasicStringVector> cols = Collections.singletonList(basicStringVector);
            BasicTable basicTable = new BasicTable(colNames, cols);
            return new JDBCResultSet(this.connection, this.statement, (Entity)basicTable, "");
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        if (TypeInfo == null) {
            List<String> colName = Arrays.asList("TYPE_NAME", "SQL_DATA_TYPE", "BYTES");
            String[] typeNameArr = new String[]{"VOID", "BOOL", "CHAR", "SHORT", "INT", "LONG", "DATE", "MONTH", "TIME", "MINUTE", "SECOND", "DATETIME", "TIMESTAMP", "NANOTIME", "NANOTIMESTAMP", "FLOAT", "DOUBLE", "SYMBOL", "STRING", "ANY"};
            int[] sqlDateTypeArr = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 24};
            int[] bytesArr = new int[]{1, 1, 1, 2, 4, 8, 4, 4, 4, 4, 4, 4, 8, 8, 8, 4, 8, 4, 0, 0};
            BasicStringVector typeName = new BasicStringVector(typeNameArr);
            BasicIntVector sqlDateType = new BasicIntVector(sqlDateTypeArr);
            BasicIntVector bytes = new BasicIntVector(bytesArr);
            List<Vector> cols = Arrays.asList(typeName, sqlDateType, bytes);
            BasicTable table = new BasicTable(colName, cols);
            TypeInfo = new JDBCResultSet(this.connection, this.statement, (Entity)table, "");
        }
        return TypeInfo;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) {
        return null;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) {
        return null;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return null;
    }

    @Override
    public String getDatabaseProductVersion() {
        return DRIVER_VERSION + Driver.SYSTEM_PROPS.getProperty("os.name") + Driver.SYSTEM_PROPS.getProperty("os.version");
    }

    @Override
    public String getNumericFunctions() {
        return "abs,acos,acosh,add,asin,asinh,atan,atanh,cbrt,ceil,cos,cosh,deg2rad,div,exp,exp2,expm1,floor,log,log2,log10,lshift,mod,mul,neg,pow,prod,ratio,reciprocal,rshift,round,sin,sinh,sqrt,square,sub,tan,tanh";
    }

    @Override
    public String getProcedureTerm() {
        return "def";
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getSQLKeywords() {
        return "context,pivot";
    }

    @Override
    public String getStringFunctions() {
        return "charAt,concat,convertEncode,crc32,decimalFormat,endsWith,format,fromUTF8,hex,ilike,isAlNum,isAlpha,isDecimal,isDigit,isLower,isNumeric,isSpace,isTitle,isUpper,left,like,lower,lpad,ltrim,md5,regexCount,regexFind,regexReplace,repeat,right,rpad,rtrim,split,startsWith,strlen,strlenu,strip,strpos,strReplace,substr,substru,toUTF8,trim,upper,wc";
    }

    @Override
    public String getSystemFunctions() {
        return "backup,defs,free,getActiveMaster,getBackupMeta,getOS,getOSBit,license,getBackupList,loadBackup,login,objs,mem,now,restore,shell,syntax";
    }

    @Override
    public String getTimeDateFunctions() {
        return "convertTZ,date,datetime,datetimeParse,gmtime,hour,localtime,minute,month,monthStart,monthEnd,nanotime,nanotimestamp,second,temporalAdd,temporalParse,time,timestamp,year,weekday";
    }

    @Override
    public String getURL() {
        return this.connection.getUrl();
    }

    @Override
    public String getUserName() {
        return "";
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private static /* synthetic */ String lambda$assembleColumnsMetaData$0(List columnIndexList, String str) {
        return columnIndexList.contains(str) ? "NO" : "YES";
    }
}

