/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Objects;

public class JDBCResultSetMetaData
implements ResultSetMetaData {
    private final BasicTable table;

    public JDBCResultSetMetaData(BasicTable table) {
        this.table = table;
    }

    @Override
    public String getCatalogName(int columnIndex) throws SQLException {
        return this.table.getColumn(this.adjustColumnIndex(columnIndex)).getDataCategory().name();
    }

    @Override
    public String getColumnClassName(int columnIndex) throws SQLException {
        return this.table.getColumn(this.adjustColumnIndex(columnIndex)).getClass().getName();
    }

    @Override
    public int getColumnCount() throws SQLException {
        if (Objects.nonNull(this.table)) {
            return this.table.columns();
        }
        return -1;
    }

    @Override
    public String getColumnLabel(int columnIndex) throws SQLException {
        return this.table.getColumnName(this.adjustColumnIndex(columnIndex));
    }

    @Override
    public int getColumnDisplaySize(int columnIndex) throws SQLException {
        return 0;
    }

    @Override
    public String getColumnName(int columnIndex) throws SQLException {
        return this.table.getColumnName(this.adjustColumnIndex(columnIndex));
    }

    @Override
    public int getColumnType(int columnIndex) throws SQLException {
        Entity.DATA_TYPE x = this.table.getColumn(this.adjustColumnIndex(columnIndex)).getDataType();
        switch (x) {
            case DT_BOOL: {
                return 16;
            }
            case DT_BYTE: {
                return 1;
            }
            case DT_SHORT: {
                return -6;
            }
            case DT_INT: {
                return 4;
            }
            case DT_LONG: {
                return -5;
            }
            case DT_DATE: {
                return 91;
            }
            case DT_TIME: {
                return 92;
            }
            case DT_DATETIME: 
            case DT_TIMESTAMP: {
                return 93;
            }
            case DT_FLOAT: {
                return 6;
            }
            case DT_DOUBLE: {
                return 8;
            }
            case DT_STRING: {
                return 12;
            }
            case DT_BLOB: {
                return 12;
            }
        }
        return 12;
    }

    @Override
    public String getColumnTypeName(int columnIndex) throws SQLException {
        return this.table.getColumn(this.adjustColumnIndex(columnIndex)).getDataType().name();
    }

    @Override
    public int getPrecision(int columnIndex) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int columnIndex) throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaName(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getTableName(int columnIndex) throws SQLException {
        return this.table.getColumnName(this.adjustColumnIndex(columnIndex));
    }

    @Override
    public boolean isAutoIncrement(int columnIndex) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int columnIndex) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int columnIndex) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int columnIndex) throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly(int columnIndex) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int columnIndex) throws SQLException {
        return true;
    }

    @Override
    public boolean isSigned(int columnIndex) throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int columnIndex) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int columnIndex) throws SQLException {
        return 2;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    private int adjustColumnIndex(int columnIndex) {
        return columnIndex - 1;
    }
}

