/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.dolphindb.jdbc.JDBCConnection;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicDate;
import com.xxdb.data.BasicFloat;
import com.xxdb.data.BasicMonth;
import com.xxdb.data.BasicShort;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.BasicTime;
import com.xxdb.data.BasicTimestamp;
import com.xxdb.data.Entity;
import com.xxdb.data.Vector;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static final int DML_OTHER = -1;
    public static final int DML_SELECT = 0;
    public static final int DML_INSERT = 1;
    public static final int DML_UPDATE = 2;
    public static final int DML_DELETE = 3;
    public static final int DML_EXEC = 4;
    static String INSERT_STRING = "(insert)\\s+(into)\\s+";
    static String MEM_TABLE_NAME = "([a-zA-Z]{1}[a-zA-Z\\d_]*)";
    static String LOAD_TABLE_NAME = "(loadTable\\(.+?\\))";
    static String TABLE_NAME_STRING = MEM_TABLE_NAME + "|" + LOAD_TABLE_NAME;
    static String VALUE_WITH_QUESTION_STRING = "\\s*(values)\\s*\\(([\\s?,]+)\\)";
    static String VALUE_STRING = "\\s*(values)\\s*\\((.+)\\)";
    static String COLNAME_STRING = "\\s*\\([a-zA-Z\\d_\\,\\s]+?\\)";
    static String DELETE_STRING = "(delete)|\\s+((?i)from)\\s+";
    static String DELETE_WHERE_STRING = "\\s+((where)\\s+(.+=.+)+)?";
    static String INSERT_TABLE_NAME_COLUMN_STRING = "(" + LOAD_TABLE_NAME + "*" + MEM_TABLE_NAME + "*)\\s*(\\((.+?)\\))*";
    static String UPDATE_STRING = "update\\s+";
    static String UPDATE_TABLE_NAME_COLUMN_STRING = "(" + LOAD_TABLE_NAME + "*" + MEM_TABLE_NAME + "*)\\s*(\\((.+?)\\))*";
    static String UPDATE_SET_AND_WHERE_STRING = "set\\s+(.+=.+)+(\\s+where\\s+(.+=.+)+)?";
    public static final Pattern DELETE_PATTERN = Pattern.compile(DELETE_STRING + MEM_TABLE_NAME + DELETE_WHERE_STRING);
    public static final Pattern DELETE_LOADTABLE_PATTERN = Pattern.compile(DELETE_STRING + LOAD_TABLE_NAME + DELETE_WHERE_STRING);
    public static final Pattern UPDATE_PATTERN = Pattern.compile("update\\s+[a-zA-Z]{1}[a-zA-Z\\d_]*\\s+set\\s+(.+=.+)+(\\s+where\\s+(.+=.+)+)?");
    public static final Pattern ASSIGN_PATTERN = Pattern.compile("[a-zA-Z]{1}[a-zA-Z\\d_]*[\\s]*=");
    public static Set<String> sqlWareHouse = new HashSet<String>();

    private static void createHashSet() {
        sqlWareHouse.add("select");
        sqlWareHouse.add("from");
        sqlWareHouse.add("where");
        sqlWareHouse.add("as");
        sqlWareHouse.add("last");
        sqlWareHouse.add("exec");
        sqlWareHouse.add("or");
        sqlWareHouse.add("and");
        sqlWareHouse.add("order");
        sqlWareHouse.add("group");
        sqlWareHouse.add("by");
        sqlWareHouse.add("interval");
        sqlWareHouse.add("cgroup");
        sqlWareHouse.add("having");
        sqlWareHouse.add("update");
        sqlWareHouse.add("set");
        sqlWareHouse.add("insert");
        sqlWareHouse.add("into");
        sqlWareHouse.add("values");
        sqlWareHouse.add("delete");
        sqlWareHouse.add("limit");
        sqlWareHouse.add("top");
        sqlWareHouse.add("map");
        sqlWareHouse.add("pivot");
        sqlWareHouse.add("partition");
        sqlWareHouse.add("sample");
        sqlWareHouse.add("desc");
        sqlWareHouse.add("asc");
        sqlWareHouse.add("sum");
        sqlWareHouse.add("max");
        sqlWareHouse.add("min");
        sqlWareHouse.add("avg");
        sqlWareHouse.add("count");
        sqlWareHouse.add("distinct");
    }

    public static Object java2db(Object o) {
        if (o instanceof BasicStringVector || o instanceof BasicAnyVector || o instanceof AbstractVector || o instanceof Vector) {
            String s = ((Vector)o).getString();
            if (((Vector)o).get(0) instanceof BasicString) {
                return Utils.dbVectorString(s);
            }
            return s;
        }
        if (o instanceof String || o instanceof BasicString) {
            return "\"" + o + "\"";
        }
        if (o instanceof Character) {
            return "'" + o + "'";
        }
        if (o instanceof Short || o instanceof BasicShort) {
            return o + "h";
        }
        if (o instanceof Float || o instanceof BasicFloat) {
            return o + "f";
        }
        if (o instanceof Date) {
            return new BasicDate(((Date)o).toLocalDate());
        }
        if (o instanceof Time) {
            return new BasicTime(((Time)o).toLocalTime());
        }
        if (o instanceof Timestamp) {
            return new BasicTimestamp(((Timestamp)o).toLocalDateTime());
        }
        if (o instanceof YearMonth) {
            return new BasicMonth((YearMonth)o);
        }
        return o;
    }

    public static String dbVectorString(String s) {
        String[] strings = s.substring(1, s.length() - 1).split(",");
        StringBuilder sb = new StringBuilder("(");
        for (String it : strings) {
            sb.append("`").append(it).append(",");
        }
        sb.delete(sb.length() - 1, sb.length());
        sb.append(")");
        return sb.toString();
    }

    public static void joinOrder(StringBuilder sb, String[] values, String join) {
        for (String item : values) {
            if (item == null || item.length() <= 0) break;
            sb.append(item).append(join);
        }
        sb.delete(sb.length() - join.length(), sb.length());
    }

    public static void parseProperties(String s, Properties prop, String split1, String split2) throws SQLException {
        String[] strings1 = s.split(split1);
        int index = 0;
        String[] var7 = strings1;
        int var8 = strings1.length;
        for (int var9 = 0; var9 < var8; ++var9) {
            String item = var7[var9];
            if (item.contains("tb_")) {
                int index1 = item.indexOf("_");
                int index2 = item.indexOf("=");
                int index3 = item.indexOf("+");
                String subString1 = item.substring(index1 + 1, index2);
                String subString2 = item.substring(index2 + 1, index3);
                String subString3 = item.substring(index3 + 1);
                prop.setProperty("script" + index, subString1 + "=loadTable(\"" + subString2 + "\",\"" + subString3 + "\")");
                ++index;
                continue;
            }
            if (item.length() <= 0) continue;
            String[] strings2 = item.split(split2);
            if (strings2.length != 2) {
                throw new SQLException(item + "     is error");
            }
            if (strings2[0].length() == 0) {
                throw new SQLException(item + "     is error");
            }
            prop.setProperty(strings2[0], strings2[1]);
        }
        prop.setProperty("length", String.valueOf(index));
    }

    public static String[] getProperties(Properties prop, String[] keys) {
        String[] properties = new String[keys.length];
        int index = 0;
        for (String key : keys) {
            properties[index] = prop.getProperty(key);
            ++index;
        }
        return properties;
    }

    private static boolean startsWith(String sentence, String key) {
        if (sentence.length() < key.length()) {
            return false;
        }
        String substr = sentence.substring(0, key.length());
        return substr.compareToIgnoreCase(key) == 0;
    }

    public static int getDml(String sql) {
        if (Utils.startsWith(sql, "select") || Utils.startsWith(sql, "SELECT")) {
            return 0;
        }
        if (sql.startsWith("insert") || sql.startsWith("INSERT")) {
            return 1;
        }
        if (sql.startsWith("update") || sql.startsWith("UPDATE")) {
            return 2;
        }
        if (sql.startsWith("delete") || sql.startsWith("DELETE")) {
            return 3;
        }
        if (sql.startsWith("exec") || sql.startsWith("EXEC")) {
            return 4;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getTableName(String sql, boolean isPrepareStatement) throws SQLException {
        String tableName = null;
        if (sql.startsWith("insert") || sql.startsWith("INSERT")) {
            String checkString = INSERT_STRING + INSERT_TABLE_NAME_COLUMN_STRING + (isPrepareStatement ? VALUE_WITH_QUESTION_STRING : VALUE_STRING);
            Pattern pattern = Pattern.compile(checkString);
            Matcher matcher = pattern.matcher(sql);
            if (!sql.matches(checkString)) throw new SQLException("Please check your SQL format: " + sql);
            if (!matcher.find()) throw new SQLException("Please check your SQL format: " + sql);
            tableName = matcher.group(3);
            if (tableName == null) throw new SQLException("Please check your SQL format: " + sql);
            if (tableName.isEmpty()) throw new SQLException("Please check your SQL format: " + sql);
            return tableName;
        }
        if (sql.startsWith("tableInsert")) {
            return sql.substring(sql.indexOf("(") + "(".length(), sql.indexOf(","));
        }
        if (sql.startsWith("append!")) {
            return sql.substring(sql.indexOf("(") + "(".length(), sql.indexOf(","));
        }
        if (sql.contains(".append!")) {
            return sql.split("\\.")[0];
        }
        if (sql.startsWith("update")) {
            String checkString = UPDATE_STRING + UPDATE_TABLE_NAME_COLUMN_STRING + UPDATE_SET_AND_WHERE_STRING;
            Pattern pattern = Pattern.compile(checkString);
            Matcher matcher = pattern.matcher(sql);
            if (!matcher.find()) throw new SQLException("check the SQl " + sql);
            return sql.substring(sql.indexOf("update") + "update".length(), sql.indexOf("set"));
        }
        if (sql.contains(".update!")) {
            return sql.split("\\.")[0];
        }
        if (!sql.startsWith("delete")) return tableName;
        Matcher matcher1 = DELETE_PATTERN.matcher(sql);
        Matcher matcher2 = DELETE_LOADTABLE_PATTERN.matcher(sql);
        int index = sql.indexOf("where");
        if (index == -1) return sql.substring(sql.indexOf("from") + "from".length()).replaceAll(";", "").trim();
        return sql.substring(sql.indexOf("from") + "from".length(), sql.indexOf("where")).trim();
    }

    public static boolean isUpdateable(String s) {
        String s1 = s.trim().split(";")[0];
        String regex = "full.*join|inner.*join|right.*join|left.*join|join.*(.*)|ej.*(.*)|sej.*(.*)|lj.*(.*)|fj.*(.*)|aj.*(.*)|cj.*(.*)|group.*by|context.*by|pivot.*by";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(s1);
        return !matcher.find();
    }

    public static String getRandomString(int length) {
        String character = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String base = character + "0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        int number = random.nextInt(character.length());
        sb.append(character.charAt(number));
        for (int i = 1; i < length; ++i) {
            number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static BasicTable Vevtor2Table(Vector vector, String sql) {
        ArrayList<String> colNames = new ArrayList<String>(1);
        if ((sql = sql.trim()).contains("as")) {
            colNames.add(sql.split(" ")[3]);
        } else {
            colNames.add(sql.split(" ")[1]);
        }
        ArrayList<Vector> cols = new ArrayList<Vector>(1);
        cols.add(vector);
        return new BasicTable(colNames, cols);
    }

    private static boolean isKeyChar(char chr) {
        return chr >= 'a' && chr <= 'z' || chr >= 'A' && chr <= 'Z' || chr >= '0' && chr <= '9' || chr == '_';
    }

    private static boolean isStringChar(char chr) {
        return chr == '\'' || chr == '\"' || chr == '`';
    }

    public static String changeCase(String sql) {
        if (sql == null) {
            return sql;
        }
        sql = sql.replaceAll("\r", "");
        Utils.createHashSet();
        StringBuilder sbSql = new StringBuilder();
        StringBuilder sbKey1 = new StringBuilder();
        char chr = '\u0000';
        char isInString = '\u0000';
        int continueSplashCount = 0;
        for (int i = 0; i < sql.length(); ++i) {
            String lowerKey;
            String key;
            chr = sql.charAt(i);
            int prevContinueSplashCount = continueSplashCount++;
            if (isInString != '\u0000') {
                if (isInString == '`') {
                    if (!Utils.isKeyChar(chr)) {
                        isInString = '\u0000';
                        continueSplashCount = 0;
                        if (Utils.isStringChar(chr)) {
                            isInString = chr;
                        }
                    }
                } else {
                    if (chr != '\\') {
                        continueSplashCount = 0;
                    }
                    if (chr == isInString && prevContinueSplashCount % 2 == 0) {
                        isInString = '\u0000';
                    }
                }
                sbSql.append(chr);
                continue;
            }
            if (Utils.isStringChar(chr)) {
                isInString = chr;
                sbSql.append(chr);
                continueSplashCount = 0;
                continue;
            }
            if (Utils.isKeyChar(chr)) {
                sbKey1.append(chr);
            } else {
                if (sbKey1.length() > 0) {
                    key = sbKey1.toString();
                    lowerKey = key.toLowerCase();
                    if (sqlWareHouse.contains(lowerKey)) {
                        sbSql.append(lowerKey);
                    } else {
                        sbSql.append(key);
                    }
                }
                sbSql.append(chr);
                sbKey1.delete(0, sbKey1.length());
            }
            if (i != sql.length() - 1 || sbKey1.length() <= 0) continue;
            key = sbKey1.toString();
            lowerKey = key.toLowerCase();
            if (sqlWareHouse.contains(lowerKey)) {
                sbSql.append(lowerKey);
                continue;
            }
            sbSql.append(key);
        }
        return sbSql.toString();
    }

    public static String changeCase(String sql, JDBCConnection connection) {
        String tableAliasValue;
        if (sql == null) {
            return sql;
        }
        sql = sql.replaceAll("\r", "");
        Utils.createHashSet();
        StringBuilder sbSql = new StringBuilder();
        StringBuilder sbKey1 = new StringBuilder();
        try {
            tableAliasValue = connection.getClientInfo("tableAlias");
        }
        catch (SQLException e) {
            throw new RuntimeException("get tableAlias prop has error!");
        }
        char chr = '\u0000';
        char isInString = '\u0000';
        int continueSplashCount = 0;
        for (int i = 0; i < sql.length(); ++i) {
            String lowerKey;
            String key;
            chr = sql.charAt(i);
            int prevContinueSplashCount = continueSplashCount++;
            if (isInString != '\u0000') {
                if (isInString == '`') {
                    if (!Utils.isKeyChar(chr)) {
                        isInString = '\u0000';
                        continueSplashCount = 0;
                        if (Utils.isStringChar(chr)) {
                            isInString = chr;
                        }
                    }
                } else {
                    if (chr != '\\') {
                        continueSplashCount = 0;
                    }
                    if (chr == isInString && prevContinueSplashCount % 2 == 0) {
                        isInString = '\u0000';
                    }
                }
                sbSql.append(chr);
                continue;
            }
            if (Utils.isStringChar(chr)) {
                isInString = chr;
                if (sbKey1.length() > 0) {
                    key = sbKey1.toString();
                    lowerKey = key.toLowerCase();
                    if (sqlWareHouse.contains(lowerKey)) {
                        if (Utils.isNotEmpty(tableAliasValue) && !tableAliasValue.contains(key)) {
                            sbSql.append(lowerKey);
                        } else if (Utils.isEmpty(tableAliasValue)) {
                            sbSql.append(lowerKey);
                        } else {
                            sbSql.append(key);
                        }
                    } else {
                        sbSql.append(key);
                    }
                    sbKey1.delete(0, sbKey1.length());
                }
                sbSql.append(chr);
                continueSplashCount = 0;
                continue;
            }
            if (Utils.isKeyChar(chr)) {
                sbKey1.append(chr);
            } else {
                if (sbKey1.length() > 0) {
                    key = sbKey1.toString();
                    lowerKey = key.toLowerCase();
                    if (sqlWareHouse.contains(lowerKey)) {
                        if (Utils.isNotEmpty(tableAliasValue) && !tableAliasValue.contains(key)) {
                            sbSql.append(lowerKey);
                        } else if (Utils.isEmpty(tableAliasValue)) {
                            sbSql.append(lowerKey);
                        } else {
                            sbSql.append(key);
                        }
                    } else {
                        sbSql.append(key);
                    }
                }
                sbSql.append(chr);
                sbKey1.delete(0, sbKey1.length());
            }
            if (i != sql.length() - 1 || sbKey1.length() <= 0) continue;
            key = sbKey1.toString();
            lowerKey = key.toLowerCase();
            if (sqlWareHouse.contains(lowerKey) && !sqlWareHouse.contains(key)) {
                if (Utils.isNotEmpty(tableAliasValue) && !tableAliasValue.contains(key)) {
                    sbSql.append(lowerKey);
                    continue;
                }
                sbSql.append(key);
                continue;
            }
            sbSql.append(key);
        }
        return sbSql.toString();
    }

    public static String getSelectOneColName(String sql) {
        String colName = sql.substring(sql.indexOf(" as ") + " as ".length());
        return colName;
    }

    public static String outerJoinToFullJoin(String sql) {
        if (!sql.contains("outer join")) {
            return sql;
        }
        sql = sql.contains("left outer join") ? sql.replaceAll("left outer join", "left join") : (sql.contains("right outer") ? sql.replaceAll("right outer join", "right join") : sql.replaceAll("outer join", "full join"));
        return sql;
    }

    public static String oracleToDolphin(String sql) {
        if (sql.contains("length")) {
            sql = sql.replaceAll("length\\s*\\(", "strlen(");
        }
        if (sql.contains("nvl")) {
            sql = sql.replaceAll("nvl\\s*\\(", "ifValid(");
        }
        if (sql.contains("replace")) {
            sql = sql.replaceAll("replace\\s*\\(", "strReplace(");
        }
        return sql;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !Utils.isEmpty(cs);
    }

    public static String parseTableAliasPropToScript(String tableAliasValue) {
        HashSet<String> aliasSet = new HashSet<String>();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String[] strs;
            for (String str : strs = tableAliasValue.split(",")) {
                String tbName;
                String finalStr;
                str = str.trim();
                String[] split = str.split("(?<!:)[:](?!/)");
                if (Utils.isEmpty(str)) {
                    throw new RuntimeException("tableAlias's value cannot be null!");
                }
                if (str.contains("dfs")) {
                    if (split.length == 1) {
                        String[] pathSplit = str.split("(?<!/)/(?!/)");
                        String alias = pathSplit[1];
                        String dbPath = pathSplit[0];
                        if (aliasSet.contains(alias)) {
                            throw new RuntimeException("Duplicate table alias found in property tableAlias: " + alias);
                        }
                        aliasSet.add(alias);
                        finalStr = alias + "=loadTable(\"" + dbPath + "\",\"" + alias + "\");\n";
                        stringBuilder.append(finalStr);
                        continue;
                    }
                    if (split.length != 2) continue;
                    if (split[0].contains("dfs") && !split[1].contains("dfs")) {
                        finalStr = Utils.parseOtherPath(str, aliasSet);
                        stringBuilder.append(finalStr);
                        continue;
                    }
                    String alias = split[0].replaceAll(":", "");
                    String path = split[1];
                    if (aliasSet.contains(alias)) {
                        throw new RuntimeException("Duplicate table alias found in property tableAlias: " + alias);
                    }
                    aliasSet.add(alias);
                    if (Utils.isEmpty(path)) {
                        throw new RuntimeException("The dfs path is empty!");
                    }
                    int lastIndex = path.lastIndexOf(47);
                    if (lastIndex == -1) continue;
                    String dbPath = path.substring(0, lastIndex);
                    tbName = path.substring(lastIndex + 1);
                    finalStr = alias + "=loadTable(\"" + dbPath + "\",\"" + tbName + "\");\n";
                    stringBuilder.append(finalStr);
                    continue;
                }
                if (str.contains("mvcc")) {
                    String mvccFilePath;
                    if (str.startsWith("mvcc") && Pattern.matches(".*[a-zA-Z]:\\\\.*", str)) {
                        String[] path = str.split("://");
                        int lastDoubleSlashIndex = path[1].lastIndexOf("\\");
                        String dropTableName = path[1].substring(0, lastDoubleSlashIndex - 1);
                        String tbNameAndAlias = path[1].substring(lastDoubleSlashIndex + 1);
                        if (aliasSet.contains(tbNameAndAlias)) {
                            throw new RuntimeException("Duplicate table alias found in property tableAlias: " + tbNameAndAlias);
                        }
                        aliasSet.add(tbNameAndAlias);
                        String finalStr2 = tbNameAndAlias + "=loadMvccTable(\"" + dropTableName + "\",\"" + tbNameAndAlias + "\");\n";
                        stringBuilder.append(finalStr2);
                        continue;
                    }
                    if (split.length == 1) {
                        List<String> mvccPathSplit = Utils.parseMvccPath(split[0]);
                        String mvccPath = mvccPathSplit.get(1);
                        String[] pathSplit = mvccPath.split("/");
                        String alias = pathSplit[pathSplit.length - 1];
                        if (aliasSet.contains(alias)) {
                            throw new RuntimeException("Duplicate table alias found in property tableAlias: " + alias);
                        }
                        aliasSet.add(alias);
                        mvccFilePath = mvccPath.substring(0, mvccPath.lastIndexOf("/"));
                        finalStr = mvccPath.startsWith("/") ? alias + "=loadMvccTable(\"" + mvccFilePath + "\",\"" + alias + "\");\n" : alias + "=loadMvccTable(\"" + mvccFilePath + "\",\"" + alias + "\");\n";
                        stringBuilder.append(finalStr);
                        continue;
                    }
                    if (split[0].contains("mvcc") && !split[1].contains("mvcc:")) {
                        finalStr = Utils.parseOtherPath(str, aliasSet);
                    } else {
                        String alias = split[0];
                        if (str.contains("\\\\")) {
                            String[] tempSplit = split[1].split("://");
                            if (aliasSet.contains(alias)) {
                                throw new RuntimeException("Duplicate table alias found in property tableAlias: " + alias);
                            }
                            aliasSet.add(alias);
                            int lastDoubleSlashIndex = split[2].lastIndexOf("\\\\");
                            String dropTableName = split[2].substring(0, lastDoubleSlashIndex);
                            tbName = split[2].substring(lastDoubleSlashIndex + 2);
                            finalStr = alias + "=loadMvccTable(\"" + tempSplit[1] + ":" + dropTableName + "\",\"" + tbName + "\");\n";
                        } else {
                            List<String> mvccPathSplit = Utils.parseMvccPath(split[1]);
                            String mvccPath = mvccPathSplit.get(1);
                            if (aliasSet.contains(alias)) {
                                throw new RuntimeException("Duplicate table alias found in property tableAlias: " + alias);
                            }
                            aliasSet.add(alias);
                            String[] pathSplit = mvccPath.split("/");
                            mvccFilePath = mvccPath.substring(0, mvccPath.lastIndexOf("/"));
                            finalStr = mvccPath.startsWith("/") ? alias + "=loadMvccTable(\"" + mvccFilePath + "\",\"" + pathSplit[pathSplit.length - 1] + "\");\n" : alias + "=loadMvccTable(\"" + mvccFilePath + "\",\"" + pathSplit[pathSplit.length - 1] + "\");\n";
                        }
                    }
                    stringBuilder.append(finalStr);
                    continue;
                }
                finalStr = Utils.parseOtherPath(str, aliasSet);
                stringBuilder.append(finalStr);
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to parse tableAlias: " + e.getMessage());
        }
        return stringBuilder.toString();
    }

    public static String parseOtherPath(String str, Set<String> aliasSet) {
        String[] split = str.split(":");
        if (split.length == 0) {
            throw new RuntimeException("The split of str's length is 0.");
        }
        String alias = split[0];
        String memTableName = split[1];
        if (aliasSet.contains(alias)) {
            throw new RuntimeException("Duplicate table alias found in property tableAlias: " + alias);
        }
        aliasSet.add(alias);
        String finalStr = alias + "=" + memTableName + ";\n";
        return finalStr;
    }

    public static List<String> parseMvccPath(String str) {
        Pattern pattern = Pattern.compile("^(.*?://)(.*)");
        Matcher matcher = pattern.matcher(str);
        ArrayList<String> result = new ArrayList<String>();
        if (matcher.find()) {
            result.add(matcher.group(1));
            result.add(matcher.group(2));
        }
        return result;
    }

    public static String getInsertColumnString(String sql) {
        String columnParam;
        Pattern pattern = Pattern.compile(INSERT_STRING + INSERT_TABLE_NAME_COLUMN_STRING + VALUE_WITH_QUESTION_STRING);
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find() && (columnParam = matcher.group(7)) != null) {
            return columnParam;
        }
        return "";
    }

    public static String getInsertValueQuestionString(String sql) {
        String columnParam;
        Pattern pattern = Pattern.compile(INSERT_STRING + INSERT_TABLE_NAME_COLUMN_STRING + VALUE_WITH_QUESTION_STRING);
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find() && (columnParam = matcher.group(9)) != null) {
            return columnParam;
        }
        return "";
    }

    public static Map<String, Integer> getInsertColumnParamInSql(String sql) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String columnParam = Utils.getInsertColumnString(sql);
        if (!columnParam.isEmpty()) {
            String[] columnParams = columnParam.split(",");
            for (int i = 0; i < columnParams.length; ++i) {
                String curCol = columnParams[i].trim().replaceAll("^[\"']|[\"']$", "");
                map.put(curCol.trim().toLowerCase(), i);
            }
            return map;
        }
        return map;
    }

    public static void checkInsertSQLValid(String sql, int columnSize) {
        String columnParam = Utils.getInsertColumnString(sql);
        String[] columnParams = columnParam.split(",");
        String QuestionMark = Utils.getInsertValueQuestionString(sql);
        String[] QuestionMarks = QuestionMark.split(",");
        if (columnParam.isEmpty()) {
            if (QuestionMarks.length != columnSize) {
                throw new RuntimeException("The number of table columns and the number of values do not match! Please check the SQL!");
            }
        } else if (columnParams.length != QuestionMarks.length) {
            throw new RuntimeException("The number of columns and the number of values do not match! Please check the SQL!");
        }
    }

    public static int transferColDefsTypesToSqlTypes(String type) {
        switch (type = type.replaceAll("\\(.*?\\)", "")) {
            case "BOOL": {
                return 16;
            }
            case "CHAR": {
                return 1;
            }
            case "SHORT": {
                return -6;
            }
            case "INT": {
                return 4;
            }
            case "LONG": {
                return -5;
            }
            case "DATE": {
                return 91;
            }
            case "TIME": {
                return 92;
            }
            case "DATETIME": 
            case "TIMESTAMP": {
                return 93;
            }
            case "FLOAT": {
                return 6;
            }
            case "DOUBLE": {
                return 8;
            }
            case "DECIMAL32": 
            case "DECIMAL64": 
            case "DECIMAL128": {
                return 3;
            }
            case "STRING": 
            case "SYMBOL": {
                return 12;
            }
            case "BLOB": {
                return 2004;
            }
        }
        return 1111;
    }

    public static boolean checkServerVersionIfSupportCatalog(JDBCConnection connection) {
        try {
            String version = connection.run("version", new ArrayList<Entity>()).getString();
            String[] _ = version.split(" ")[0].split("\\.");
            int v0 = Integer.parseInt(_[0]);
            int v1 = Integer.parseInt(_[1]);
            int v2 = Integer.parseInt(_[2]);
            return v0 == 3;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

