package com.domeke.core.base.config;

/**
 * 常量数据字典
 * 
 * @author lijiasen@126.com
 */
public abstract class DictKeys {

	public static final String UPLOAD_FILE_PATH = "upload_file_path";

	public static final String UPLOAD_CONTEXT = "upload_context";

	public static final String SOLR_ADMIN_URL = "solr_admin_url";

	/**
	 * URL缓存Key
	 * 
	 */
	public static final String CACHE_NAME_PAGE = "SimplePageCachingFilter";

	/**
	 * 系统缓存，主要是权限和数据字典等
	 */
	public static final String CACHE_NAME_SYSTEM = "system";

	/**
	 * 扫描的包
	 */
	public static final String CONFIG_SCAN_PACKAGE = "config.scan.package";

	/**
	 * 扫描的jar
	 */
	public static final String CONFIG_SCAN_JAR = "config.scan.jar";

	/**
	 * 开发模式
	 */
	public static final String CONFIG_DEVMODE = "config.devMode";

	/**
	 * 是否重新构建Lucene索引（构建索引实在是慢）
	 */
	public static final String CONFIG_LUCENEINDEX = "config.luceneIndex";

	/**
	 * 加密密钥
	 */
	public static final String CONFIG_SECURITYKEY_KEY = "config.securityKey";

	/**
	 * 密码最大错误次数
	 */
	public static final String CONFIG_PASSERRORCOUNT_KEY = "config.passErrorCount";

	/**
	 * 密码错误最大次数后间隔登陆时间（小时）
	 */
	public static final String CONFIG_PASSERRORHOUR_KEY = "config.passErrorHour";

	/**
	 * #文件上传大小限制 10 * 1024 * 1024 = 10M
	 */
	public static final String CONFIG_MAXPOSTSIZE_KEY = "config.maxPostSize";

	/**
	 * # cookie 值的时间
	 */
	public static final String CONFIG_MAXAGE_KEY = "config.maxAge";

	/**
	 * # 域名或者服务器IP，多个逗号隔开，验证Referer时使用
	 */
	public static final String CONFIG_DOMAIN_KEY = "config.domain";

	/**
	 * mail 配置：邮件服务器地址
	 */
	public static final String CONFIG_MAIL_HOST = "config.mail.host";

	/**
	 * mail 配置：邮件服务器端口
	 */
	public static final String CONFIG_MAIL_PORT = "config.mail.port";

	/**
	 * mail 配置：邮件服务器账号
	 */
	public static final String CONFIG_MAIL_FROM = "config.mail.from";

	/**
	 * mail 配置：邮件服务器名称
	 */
	public static final String CONFIG_MAIL_USERNAME = "config.mail.userName";

	/**
	 * mail 配置：邮件服务器密码
	 */
	public static final String CONFIG_MAIL_PASSWORD = "config.mail.password";

	/**
	 * mail 配置：接收邮件地址
	 */
	public static final String CONFIG_MAIL_TO = "config.mail.to";

	/**
	 * 当前数据库类型
	 */
	public static final String DB_TYPE_KEY = "db.type";

	/**
	 * 当前数据库类型：postgresql
	 */
	public static final String DB_TYPE_POSTGRESQL = "postgresql";

	/**
	 * 当前数据库类型：mysql
	 */
	public static final String DB_TYPE_MYSQL = "mysql";

	/**
	 * 当前数据库类型：oracle
	 */
	public static final String DB_TYPE_ORACLE = "oracle";

	/**
	 * 数据库连接参数：驱动
	 */
	public static final String DB_CONNECTION_DRIVERCLASS = "jdbc.driverClass";

	/**
	 * 数据库连接参数：连接URL
	 */
	public static final String DB_CONNECTION_JDBCURL = "jdbc.url";

	/**
	 * 数据库连接参数：用户名
	 */
	public static final String DB_CONNECTION_USERNAME = "jdbc.username";

	/**
	 * 数据库连接参数：密码
	 */
	public static final String DB_CONNECTION_PASSWORD = "jdbc.password";

	/**
	 * 数据库连接参数：数据库服务器IP
	 */
	public static final String DB_CONNECTION_IP = "db_ip";

	/**
	 * 数据库连接参数：数据库服务器端口
	 */
	public static final String DB_CONNECTION_PORT = "db_port";

	/**
	 * 数据库连接参数：数据库名称
	 */
	public static final String DB_CONNECTION_DBNAME = "db_name";

	/**
	 * 数据库连接池参数：初始化连接大小
	 */
	public static final String DB_INITIALSIZE = "db.initialSize";

	public static final String DB_SHOWSQL = "db.showSQL";

	/**
	 * 数据库连接池参数：最少连接数
	 */
	public static final String DB_MINIDLE = "db.minIdle";

	/**
	 * 数据库连接池参数：最多连接数
	 */
	public static final String DB_MAXACTIVE = "db.maxActive";

	/**
	 * 
	 */
	public static final String DB_MAXWAIT = "db.maxWait";

	public static final String DB_FILTERS = "db.filters";

	/**
	 * 
	 */
	public static final String DB_TIMEBETWEENCONNECTERRORMILLIS = "db.timeBetweenConnectErrorMillis";

	/**
	 * 
	 */
	public static final String DB_TIMEBETWEENEVICTIONRUNSMILLIS = "db.timeBetweenEvictionRunsMillis";

	/**
	 * 
	 */
	public static final String DB_MINEVICTABLEIDLETIMEMILLIS = "db.minEvictableIdleTimeMillis";

	/**
	 * 
	 */
	public static final String DB_VALIDATIONQUERY_MYSQL = "mysql.db.validationQuery";

	public static final String DB_VALIDATIONQUERY_ORACLE = "oracle.db.validationQuery";

	public static final String DB_VALIDATIONQUERY = "db.validationQuery";

	public static final String DB_TESTWHILEIDLE = "db.testWhileIdle";

	public static final String DB_TESTONBORROW = "db.testOnBorrow";

	public static final String DB_TESTONRETURN = "db.testOnReturn";

	public static final String DB_REMOVEABANDONED = "db.removeAbandoned";

	public static final String DB_REMOVEABANDONEDTIMEOUTMILLIS = "db.removeAbandonedTimeoutMillis";

	public static final String DB_MAXPOOLPREPAREDSTATEMENTPERCONNECTIONSIZE = "db.maxPoolPreparedStatementPerConnectionSize";

	public static final String DB_LOGABANDONED = "db.logAbandoned";

	/**
	 * 主数据源名称：系统主数据源
	 */
	public static final String DB_DATASOURCE_MAIN = "db.dataSource.main";

	/**
	 * druid 监控
	 */
	public static final String DB_JDBC_STAT = "db.jdbc.stat";

	/**
	 * 分页参数初始化值：默认显示第几页
	 */
	public static final int DEFAULT_PAGENUMBER = 1;

	/**
	 * 分页参数初始化值：默认每页显示几多
	 */
	public static final int DEFAULT_PAGESIZE = 16;

	/**
	 * 用户登录状态码：用户不存在
	 */
	public static final int LOGIN_INFO_0 = 0;

	/**
	 * 用户登录状态码：停用账户
	 */
	public static final int LOGIN_INFO_1 = 1;

	/**
	 * 用户登录状态码：密码错误次数超限
	 */
	public static final int LOGIN_INFO_2 = 2;

	/**
	 * 用户登录状态码：密码验证成功
	 */
	public static final int LOGIN_INFO_3 = 3;

	/**
	 * 用户登录状态码：密码验证失败
	 */
	public static final int LOGIN_INFO_4 = 4;

}
