package com.domeke.core.beetl;

import org.beetl.core.GroupTemplate;
import org.beetl.ext.jfinal.BeetlRender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomekeBeetlRender extends BeetlRender {

	private static Logger log = LoggerFactory.getLogger(DomekeBeetlRender.class);

	/**
	 * render耗时计算key
	 */
	public static final String renderTimeKey = "renderTime";

	public DomekeBeetlRender(GroupTemplate gt, String view) {
		super(gt, view);
	}

	public void render() {
		long start = System.currentTimeMillis();
		log.debug("DomekeBeetlRender render start time = " + start);

		super.render();

		long end = System.currentTimeMillis();
		long renderTime = end - start;
		log.debug("DomekeBeetlRender render end time = " + end + "，renderTime = " + renderTime);

		request.setAttribute(DomekeBeetlRender.renderTimeKey, renderTime);
	}

}
