package com.domeke.core.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.domeke.core.kit.WebKit;
import com.domeke.core.model.Loginlog;
import com.domeke.core.model.Menu;
import com.domeke.core.model.User;
import com.google.common.collect.Lists;
import com.jfinal.core.Controller;

public class BaseController extends Controller {

	/**
	 * 获取当前用户信息
	 * 
	 * @param request
	 * @param userAgentVali
	 * @return
	 */
	public User getCurrentUser(HttpServletRequest request, boolean userAgentVali) {
		return WebKit.getCurrentUser(request, userAgentVali);
	}

	/**
	 * 设置当前用户信息
	 * 
	 * @param request
	 * @param response
	 * @param user
	 * @param autoLogin
	 *            是否自动登录
	 */
	public void setCurrentUser(HttpServletRequest request, HttpServletResponse response, User user, boolean autoLogin) {
		WebKit.setCurrentUser(request, response, user, autoLogin);
	}

	/**
	 * 获取菜单列表,并设置到属性表里
	 * 
	 * @param moduleName
	 *            模块名称
	 * @return
	 */
	public void setMenuList(String moduleName) {
		List<Menu> menuList = Lists.newArrayList();

		setAttr("menuList", menuList);
	}

	protected Loginlog reqLoginLog; // 访问日志

	public Loginlog getReqLoginLog() {
		return reqLoginLog;
	}

	public void setReqLoginLog(Loginlog reqLoginLog) {
		this.reqLoginLog = reqLoginLog;
	}
}
