package com.domeke.core.kit;

import java.util.List;

import com.domeke.core.base.config.DictKeys;
import com.domeke.core.model.User;
import com.domeke.core.service.cache.ICacheService;
import com.google.common.collect.Lists;
import com.jfinal.kit.PropKit;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.ehcache.CacheKit;
import com.jfinal.plugin.redis.Cache;
import com.jfinal.plugin.redis.Redis;

public class CodeKit {

	public final static String CACHE_TYPE_REDIS = "redis";

	public final static String CACHETYPE = PropKit.use("domeke.properties").get("cache_type");

	public static User getUser(String codeKey) {
		Cache cache = Redis.use();
		String cacheKey = ICacheService.CACHESTART_USER + codeKey;
		User user = null;
		if (CACHE_TYPE_REDIS.equals(CACHETYPE)) {
			user = cache.get(cacheKey);
		} else {
			user = CacheKit.get(DictKeys.CACHE_NAME_SYSTEM, cacheKey);
		}

		return user;
	}

	/**
	 * 获取码表值
	 * 
	 * @param codeType
	 *            码表名称
	 * @param codeKey
	 *            码表对应键
	 * @return
	 */
	public static String getValue(String codeType, String codeKey) {
		String cacheKey = ICacheService.CACHESTART_DICT + codeType + "_" + codeKey;
		cacheKey = cacheKey.toUpperCase();
		Object value = "";
		Cache cache = Redis.use();
		if (CACHE_TYPE_REDIS.equals(CACHETYPE)) {
			value = cache.get(cacheKey);
		} else {
			value = CacheKit.get(DictKeys.CACHE_NAME_SYSTEM, cacheKey);
		}

		return value != null ? value.toString() : "";
	}

	/**
	 * 获取码表值
	 * 
	 * @param codeType
	 *            码表名称
	 * @param codeKey
	 *            码表对应键
	 * @return
	 */
	public static String getName(String codeType, String codeValue) {
		String cacheKey = ICacheService.CACHESTART_DICT_NAME + codeType + "_" + codeValue;
		cacheKey = cacheKey.toUpperCase();
		Object value = "";
		Cache cache = Redis.use();
		if (CACHE_TYPE_REDIS.equals(CACHETYPE)) {
			value = cache.get(cacheKey);
		} else {
			value = CacheKit.get(DictKeys.CACHE_NAME_SYSTEM, cacheKey);
		}
		return value != null ? value.toString() : "";
	}

	/**
	 * 返回码表列表
	 * 
	 * @param codeType
	 * @return
	 */
	public static List<Record> getList(String codeType) {
		codeType = ICacheService.CACHESTART_DICT_LIST + codeType;
		codeType = codeType.toUpperCase();
		List<Record> cacheValue = Lists.newArrayList();
		Cache cache = Redis.use();
		if (CACHE_TYPE_REDIS.equals(CACHETYPE)) {
			cacheValue = cache.get(codeType);
		} else {
			cacheValue = CacheKit.get(DictKeys.CACHE_NAME_SYSTEM, codeType);
		}

		return cacheValue;
	}

	/**
	 * 根据名称获取码表值
	 * 
	 * @param codeType
	 *            码表名称
	 * @param codeKey
	 *            码表对应键
	 * @return
	 */

	public static String getValueByName(String codeType, String codeName) {
		String cacheKey = ICacheService.CACHESTART_DICT_NAME + codeType + "_" + codeName;
		cacheKey = cacheKey.toUpperCase();
		Object value = "";
		Cache cache = Redis.use();
		if (CACHE_TYPE_REDIS.equals(CACHETYPE)) {

			value = cache.get(cacheKey);
		} else {
			value = CacheKit.get(DictKeys.CACHE_NAME_SYSTEM, cacheKey);
		}

		return value != null ? value.toString() : "";
	}

}
