package com.domeke.core.kit;

import java.text.DecimalFormat;
import java.util.UUID;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 公共工具类
 * 
 * @author lijiasen@126.com 2012-9-7 下午2:20:06
 */
public class CommonKit {

	@SuppressWarnings("unused")
	private static Logger log = LoggerFactory.getLogger(CommonKit.class);

	/**
	 * double精度调整
	 * 
	 * @param doubleValue
	 *            需要调整的值123.454
	 * @param format
	 *            目标样式".##"
	 * @return
	 */
	public static String decimalFormatToString(double doubleValue, String format) {
		DecimalFormat myFormatter = new DecimalFormat(format);
		String formatValue = myFormatter.format(doubleValue);
		return formatValue;
	}

	public static String getUuidByJdk(boolean is32bit) {
		String uuid = UUID.randomUUID().toString();
		if (is32bit) {
			return uuid.toString().replace("-", "");
		}
		return uuid;
	}

	public static void main(String[] args) {
		System.out.println(getUuidByJdk(true));
	}

}
