package com.domeke.core.kit;

import java.util.List;

import com.domeke.core.service.cache.ICacheService;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.redis.Redis;

public class DistrictKit {

	/**
	 * 获取省份码表值
	 * 
	 * @param parentId
	 *            名称
	 * @param codeKey
	 *            码表对应键
	 * @return
	 */
	public static List<Record> getProvince() {
		List<Record> value = Redis.use().get(ICacheService.CACHESTART_DISTRICT_PROVINCE_LIST);
		return value != null ? value : null;
	}

	/**
	 * 
	 * @param province
	 * @return
	 */
	public static List<Record> getCityList(String province) {
		List<Record> value = Redis.use().get(ICacheService.CACHESTART_DISTRICT_CITY_LIST + province);
		return value != null ? value : null;
	}

	public static List<Record> getAreaList(String city) {
		List<Record> value = Redis.use().get(ICacheService.CACHESTART_DISTRICT_AREA_LIST + city);
		return value != null ? value : null;
	}

	public static Record getDistrict(String distKey, String codeKey) {
		return Redis.use().get(distKey + codeKey);
	}

	public static Record getDistrict(String codeKey) {
		return Redis.use().get(ICacheService.CACHESTART_DISTRICT + codeKey);
	}

	public static String getName(String codevalue) {
		String result = "";
		Record code = getDistrict(codevalue);
		if (code != null && code.get("shortname") != null) {
			result = code.getStr("shortname");
		}
		return result;
	}

}
