package com.domeke.core.kit;

import org.apache.commons.lang.StringUtils;

import com.domeke.core.base.config.DictKeys;
import com.jfinal.plugin.druid.DruidPlugin;
import com.jfinal.plugin.druid.DruidStatViewHandler;

public class DruidKit {

	/**
	 * 根据传入的数据源名称获取数据源信息
	 * 
	 * @param dataSource
	 * @return
	 */
	public static DruidPlugin getDruidPlugin(String dataSource) {

		return null;
	}

	/**
	 * 获取默认数据源
	 * 
	 * @return
	 */
	public static DruidPlugin getDruidPlugin() {
		String url = PropsKit.getString(DictKeys.DB_CONNECTION_JDBCURL);
		String password = PropsKit.getString(DictKeys.DB_CONNECTION_PASSWORD);
		// try {
		// password = ConfigTools.decrypt(getProperty("jdbc.password"));
		// } catch (Exception e) {
		// logger.error("解密配置文件出错", e);
		// throw new RuntimeException(e);
		// }
		String username = PropsKit.getString(DictKeys.DB_CONNECTION_USERNAME);
		String driveClass = PropsKit.getString(DictKeys.DB_CONNECTION_DRIVERCLASS);
		DruidPlugin druidPlugin = new DruidPlugin(url, username, password);
		druidPlugin.setDriverClass(driveClass);

		if (StringUtils.isNotBlank(PropsKit.getString(DictKeys.DB_FILTERS))) {
			druidPlugin.setFilters(PropsKit.getString(DictKeys.DB_FILTERS));
		}

		if (PropsKit.getInt(DictKeys.DB_INITIALSIZE) > 0) {
			int initialSize = PropsKit.getInt(DictKeys.DB_INITIALSIZE);
			druidPlugin.setInitialSize(initialSize);
		}
		if (PropsKit.getInt(DictKeys.DB_MINIDLE) > 0) {
			int minIdle = PropsKit.getInt(DictKeys.DB_MINIDLE);
			druidPlugin.setMinIdle(minIdle);
		}

		if (PropsKit.getInt(DictKeys.DB_MAXACTIVE) > 0) {

			int maxActive = PropsKit.getInt(DictKeys.DB_MAXACTIVE);
			druidPlugin.setMaxActive(maxActive);
		}

		if (PropsKit.getLong(DictKeys.DB_MAXWAIT) > 0) {
			long maxWait = PropsKit.getLong(DictKeys.DB_MAXWAIT);

			druidPlugin.setMaxWait(maxWait);
		}

		if (PropsKit.getLong(DictKeys.DB_TIMEBETWEENCONNECTERRORMILLIS) > 0) {

			long timeBetweenConnectErrorMillis = PropsKit.getLong(DictKeys.DB_TIMEBETWEENCONNECTERRORMILLIS);
			druidPlugin.setTimeBetweenConnectErrorMillis(timeBetweenConnectErrorMillis);
		}

		if (PropsKit.getLong(DictKeys.DB_TIMEBETWEENEVICTIONRUNSMILLIS) > 0) {
			long timeBetweenEvictionRunsMillis = PropsKit.getLong(DictKeys.DB_TIMEBETWEENEVICTIONRUNSMILLIS);
			druidPlugin.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);

		}

		if (PropsKit.getLong(DictKeys.DB_MINEVICTABLEIDLETIMEMILLIS) > 0) {

			long minEvictableIdleTimeMillis = PropsKit.getLong(DictKeys.DB_MINEVICTABLEIDLETIMEMILLIS);
			druidPlugin.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
		}

		if (StringUtils.isNotBlank(PropsKit.getString(DictKeys.DB_VALIDATIONQUERY))) {

			String validationQuery = PropsKit.getString(DictKeys.DB_VALIDATIONQUERY);
			druidPlugin.setValidationQuery(validationQuery);
		}
		if (PropsKit.getBoolean(DictKeys.DB_TESTWHILEIDLE)) {
			boolean testWhileIdle = PropsKit.getBoolean(DictKeys.DB_TESTWHILEIDLE);
			druidPlugin.setTestWhileIdle(testWhileIdle);
		}
		boolean testOnBorrow = PropsKit.getBoolean(DictKeys.DB_TESTONBORROW);
		druidPlugin.setTestOnBorrow(testOnBorrow);
		boolean testOnReturn = PropsKit.getBoolean(DictKeys.DB_TESTONBORROW);
		druidPlugin.setTestOnReturn(testOnReturn);

		boolean removeAbandoned = PropsKit.getBoolean(DictKeys.DB_REMOVEABANDONED);
		druidPlugin.setRemoveAbandoned(removeAbandoned);
		long removeAbandonedTimeoutMillis = PropsKit.getLong(DictKeys.DB_REMOVEABANDONEDTIMEOUTMILLIS);
		druidPlugin.setRemoveAbandonedTimeoutMillis(removeAbandonedTimeoutMillis);
		boolean logAbandoned = PropsKit.getBoolean(DictKeys.DB_LOGABANDONED);
		druidPlugin.setLogAbandoned(logAbandoned);

		int maxPoolPreparedStatementPerConnectionSize = PropsKit.getInt(DictKeys.DB_MAXPOOLPREPAREDSTATEMENTPERCONNECTIONSIZE);
		// 只要maxPoolPreparedStatementPerConnectionSize>0,poolPreparedStatements就会被自动设定为true，参照druid的源�?
		druidPlugin.setMaxPoolPreparedStatementPerConnectionSize(maxPoolPreparedStatementPerConnectionSize);
		return druidPlugin;

	}

	public static DruidStatViewHandler getHandlerProperty() {
		DruidStatViewHandler dsvh = new DruidStatViewHandler(PropsKit.getString(DictKeys.DB_JDBC_STAT));
		return dsvh;
	}

}
