package com.domeke.core.kit;

import com.domeke.core.plugin.PropertiesPlugin;
import com.jfinal.kit.StrKit;

public class PropsKit {

	private static Object getProperty(String key) {
		return PropertiesPlugin.getParamMapValue(key);
	}

	public static String getString(String key) {
		Object value = getProperty(key);
		return value != null ? value.toString() : null;
	}

	public static int getInt(String key) {
		String value = getString(key);
		return (StrKit.isNotBlank(value)) ? Integer.parseInt(value) : 0;
	}

	public static boolean getBoolean(String key) {
		String value = getString(key);
		return (StrKit.isNotBlank(value)) ? Boolean.parseBoolean(value) : false;
	}

	public static long getLong(String key) {
		String value = getString(key);
		return (StrKit.isNotBlank(value)) ? Long.parseLong(value) : 0;
	}

}
