/**
 * 
 */
package com.domeke.core.model;

import java.util.HashMap;
import java.util.Map;

import com.domeke.core.base.config.DictKeys;
import com.domeke.core.service.cache.ICacheService;
import com.domeke.core.tablebind.TableBind;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.redis.Cache;
import com.jfinal.plugin.redis.Redis;

/**
 * @author lijiasen
 * 
 * <pre>
 * </pre>
 */
@TableBind(tableName = "code_table", pkName = "codetableid")
public class CodeTable extends BaseModel<CodeTable> implements Comparable<Object> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 86121109381534424L;

	@Override
	public int compareTo(Object o) {
		if (this == o) {
			return 0;
		} else if (o != null && o instanceof CodeTable) {
			CodeTable t = (CodeTable) o;
			Object ts = this.get("sortnum");
			Integer tsInt = Integer.parseInt(ts.toString());
			Object os = t.get("sortnum");
			Integer osInt = Integer.parseInt(os.toString());
			return tsInt.compareTo(osInt);
		} else {
			return -1;
		}
	}

	/**
	 * 
	 */
	public static CodeTable dao = new CodeTable();

	public void saveCodeTable() {
		this.save();

		Cache cache = Redis.use();
		String cacheKey = "";
		String codeType = "";
		String codeKey = "";
		codeType = this.get("CODETYPE");
		codeKey = this.get("CODEKEY");
		cacheKey = codeType + "_" + codeKey;
		cache.set((ICacheService.CACHESTART_DICT + cacheKey).toUpperCase(), this.getStr("codevalue"));
		cache.set((ICacheService.CACHESTART_DICT_NAME + cacheKey).toUpperCase(), this.getStr("codevalue"));
	}

	public Page<CodeTable> queryCodeTableList(int pageNumber, Map<String, Object> params) {
		Map<String, Object> filteMap = new HashMap<String, Object>(params);
		String select = "select * ";
		String sqlExceptSelect = getSql("domeke.core.codeTable.queryCodeTableByParams", filteMap);
		Page<CodeTable> page = CodeTable.dao.paginate(pageNumber, DictKeys.DEFAULT_PAGESIZE, select, sqlExceptSelect);
		return page;
	}
}
