package com.domeke.core.model;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import com.domeke.core.base.config.DictKeys;
import com.domeke.core.tablebind.TableBind;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Page;

/**
 * 公司model
 * 
 * @author Administrator
 *
 */
@TableBind(tableName = "company", pkName = "companyid")
public class Company extends BaseModel<Company> {

	private static final long serialVersionUID = 1L;
	public static Company dao = new Company();

	/**
	 * 分页查询
	 * 
	 * @param pageNumber
	 * @param filter
	 * @return
	 */
	public Page<Company> queryCompanyList(int pageNumber, Map<String, Object> filter) {
		String select = "select m.*,cm.companyname as parentname ";
		String sqlExceptSelect = getSql("domeke.core.company.queryByFilter", filter);
		Page<Company> page = Company.dao.paginate(pageNumber, DictKeys.DEFAULT_PAGESIZE, select, sqlExceptSelect);
		return page;
	}

	/**
	 * 获取公司码表
	 * 
	 * @return
	 */
	public List<Company> queryCompanyCodedata() {
		return dao.find(getSql("domeke.core.company.queryCompanyCodedata"));
	}

	/**
	 * 检查公司名是否已存在
	 * 
	 * @param companyname
	 * @return
	 */
	public int checkName(String companyname) {
		BigDecimal big = Db.queryBigDecimal(getSql("domeke.core.company.checkName"), companyname);
		return big.intValue();
	}

}
