/**
 * 
 */
package com.domeke.core.model;

import java.util.List;

import com.google.common.collect.Lists;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;

/**
 * @author lijiasen@domeke.com
 *
 */
public class District extends BaseModel<District> {

	public static District dao = new District();

	/**
	 * 
	 */
	private static final long serialVersionUID = 2097124923923530543L;

	public List<Record> getProvinceList() {

		String sql = getSql("domeke.core.district.query");
		List<Record> list = Db.find(sql, 1);

		return list;
	}

	public List<Record> getCityList() {
		String sql = getSql("domeke.core.district.query");
		List<Record> list = Db.find(sql, 2);
		return list;
	}

	public List<Record> getAreaList() {
		String sql = getSql("domeke.core.district.query");
		List<Object> params = Lists.newArrayList();
		params.add(3);
		List<Record> list = Db.find(sql, 3);
		return list;
	}

	public List<Record> getAll() {
		String sql = getSql("domeke.core.district.all");
		List<Record> list = Db.find(sql);
		return list;
	}

}
