/**
 * 
 */
package com.domeke.core.model;
import java.util.List;
import java.util.Map;
import com.domeke.core.model.BaseModel;
import com.domeke.core.tablebind.TableBind;

/**
 * @author lijiasen
 * 
 * <pre>
 * </pre>
 */
@TableBind(tableName = "fileattachment", pkName = "fileid")
public class FileAttachment extends BaseModel<FileAttachment> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 7479567803830010699L;

	public static FileAttachment dao = new FileAttachment();

	public List<FileAttachment> queryFileAttachmentListByParams(Map<String, Object> filterData) {
		String sql = getSql("com.domeke.zzx.fileattachment.queryAll");
		String filter = getParamsFilter(filterData);
		if (filter != null && filter.length() > 0)
			sql += " and " + filter;
		List<FileAttachment> fileAttachmentList = find(sql);
		return fileAttachmentList;
	}

	/**
	 * 解析传递参数
	 * 
	 * @param filterData
	 * @return
	 */
	private String getParamsFilter(Map<String, Object> filterData) {
		String filter = "";
		if (filterData != null && filterData.size() > 0) {
			for (String key : filterData.keySet()) {
				Object value = filterData.get(key);
				if (value != null && ((String) value).length() > 0) {
					if (filter.length() > 0)
						filter += " and ";
					filter += " " + key + "='" + value + "' ";
				}
			}
		}
		return filter;
	}
	/**
	 * 获取 系列 文件集
	 * @param filterData
	 * @return
	 */
	public List<FileAttachment> findFileAttachmentsByParams(Map<String, Object> filterData){
		String select = "select * ";
		String sql = select + getSql("com.domeke.zzx.fileattachment.findFileAttachmentByParams",filterData);
		List<FileAttachment> fileAttachments = this.find(sql);
		return fileAttachments;
	}
	
	/**
	 * 多表关联  fileattachment community house room
	 * @param filterData
	 * @return
	 */
	public List<FileAttachment> findFCHRByParams(Map<String, Object> filterData){
		String sql = getSql("com.domeke.zzx.fileattachment.findFCHRByParams",filterData);
		return this.find(sql);
	}
	
}
