package com.domeke.core.model;

import java.util.Map;

import com.domeke.core.base.config.DictKeys;
import com.domeke.core.tablebind.TableBind;
import com.jfinal.plugin.activerecord.Page;

@TableBind(tableName = "module", pkName = "moduleid")
public class Module extends BaseModel<Module> {

	private static final long serialVersionUID = 1L;

	public static Module dao = new Module();

	/**
	 * 分页查询
	 * 
	 * @param pageNumber
	 * @param filter
	 * @return
	 */
	public Page<Module> queryModuleList(int pageNumber, Map<String, Object> filter) {
		String select = " select m.*,cm.modulename as parentmodulename ";
		String sqlExceptSelect = getSql("domeke.core.module.queryByFilter", filter);
		Page<Module> page = Module.dao.paginate(pageNumber, DictKeys.DEFAULT_PAGESIZE, select, sqlExceptSelect);
		return page;
	}
}
