package com.domeke.core.model;

import java.util.Map;

import com.domeke.core.base.config.DictKeys;
import com.domeke.core.service.cache.ICacheService;
import com.domeke.core.tablebind.TableBind;
import com.jfinal.plugin.activerecord.Page;

/**
 * 权限对象
 * 
 * @author Administrator
 *
 */
@TableBind(tableName = "operator", pkName = "operatorid")
public class Operator extends BaseModel<Operator> implements ICacheService {

	private static final long serialVersionUID = 1L;

	public static Operator dao = new Operator();

	public Page<Operator> queryOperatorList(int pageNumber, Map<String, Object> filter) {
		String select = "select * ";
		String sqlExceptSelect = getSql("domeke.core.operator.queryByFilter", filter);
		Page<Operator> page = Operator.dao.paginate(pageNumber, DictKeys.DEFAULT_PAGESIZE, select, sqlExceptSelect);
		return page;
	}

	@Override
	public void cacheAll() {
	}

	@Override
	public void removeCache() {
	}

	@Override
	public void removeCache(String cacheKey) {
	}

	@Override
	public <T> T getCache(String cacheKey) {
		return null;
	}
}
