/**
 * 
 */
package com.domeke.core.model;

import java.math.BigDecimal;
import java.util.Map;

import com.domeke.core.base.config.DictKeys;
import com.domeke.core.tablebind.TableBind;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Page;

/**
 * 角色model
 * 
 * @author Administrator
 *
 */
@TableBind(tableName = "role", pkName = "roleid")
public class Role extends BaseModel<Role> {
	/**
	 * 
	 */
	private static final long serialVersionUID = 345690344024256464L;
	public static Role dao = new Role();

	/**
	 * 分页查询
	 * 
	 * @param pageNumber
	 * @param filter
	 * @return
	 */
	public Page<Role> queryRoleList(int pageNumber, Map<String, Object> filter) {
		String select = "select * ";
		String sqlExceptSelect = getSql("domeke.core.role.queryByFilter", filter);
		Page<Role> page = Role.dao.paginate(pageNumber, DictKeys.DEFAULT_PAGESIZE, select, sqlExceptSelect);
		return page;
	}

	/**
	 * 检查角色名是否重复
	 * 
	 * @param rolename
	 * @return
	 */
	public int checkName(String rolename) {
		BigDecimal big = Db.queryBigDecimal(getSql("domeke.core.role.checkRole"), rolename);
		return big.intValue();
	}

}
