/**
 * 
 */
package com.domeke.core.model;

import java.util.Map;

import com.domeke.core.base.config.DictKeys;
import com.domeke.core.kit.EncryptionKit;
import com.domeke.core.kit.HtmlTagKit;
import com.domeke.core.tablebind.TableBind;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;

/**
 * 用户model
 * 
 * @author Administrator
 *
 */
@TableBind(tableName = "cwd_user", pkName = "userid")
public class User extends BaseModel<User> {

	private static final long serialVersionUID = 1L;

	public static User dao = new User();

	// TODO 加盐
	public User login(String username) {
		String sql = getSql("domeke.core.user.login");
		return dao.findFirst(sql, username);
	}

	public void saveUser() {
		HtmlTagKit.processHtmlSpecialTag(this, "username", "email", "mobile");
		String pasword = EncryptionKit.md5Encrypt(this.getStr("password"));
		this.set("password", pasword);
		this.save();
	}

	public void updateUser() {
		HtmlTagKit.processHtmlSpecialTag(this, "email", "mobile");
		this.update();
	}

	public void updatePassword() {
		this.update();
	}

	public Page<User> queryUserList(int pageNumber, Map<String, Object> filter) {
		String select = "select * ";
		String sqlExceptSelect = getSql("domeke.core.user.queryByFilter", filter);
		Page<User> page = User.dao.paginate(pageNumber, DictKeys.DEFAULT_PAGESIZE, select, sqlExceptSelect);
		return page;
	}

	public String getUserOperator(User user) {
		String sql = getSql("domeke.core.user.getUserOperator");
		String id = user.getPKValue();
		Record record = Db.findFirst(sql, id);
		// add by linderen on 20150924 start
		// 当用户未分配权限时
		if (null == record) {
			return "";
		}
		// add by linderen on 20150924 end
		return record.get("operatorids");
	}

}
