/**
 * 
 */
package com.domeke.core.model;

import java.util.Map;

import com.domeke.core.base.config.DictKeys;
import com.domeke.core.tablebind.TableBind;
import com.google.common.collect.Maps;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;

/**
 * 用户角色model
 * 
 * @author Administrator
 *
 */
@TableBind(tableName = "user_role", pkName = "userroleid")
public class UserRole extends BaseModel<UserRole> {
	private static final long serialVersionUID = -7031997537678597633L;
	public static UserRole dao = new UserRole();

	/**
	 * 分页
	 * 
	 * @param pageNumber
	 * @param filter
	 * @return
	 */
	public Page<Record> queryUserRoleList(int pageNumber, Map<String, Object> filter) {
		String select = "select ur.*,u.username,r.rolename ";
		String sqlExceptSelect = getSql("domeke.core.userRole.queryByFilter", filter);
		Page<Record> page = Db.paginate(pageNumber, DictKeys.DEFAULT_PAGESIZE, select, sqlExceptSelect);
		return page;
	}

	public UserRole queryUserRole(String userId, String roleId) {
		Map<String, Object> filter = Maps.newHashMap();
		filter.put("userid", userId);
		filter.put("roleid", roleId);
		return UserRole.dao.findFirst(getSql("domeke.core.userRole.queryUserRole", filter));
	}
}
