package com.domeke.core.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.domeke.core.base.config.DictKeys;
import com.google.common.collect.Maps;
import com.jfinal.core.Const;
import com.jfinal.kit.PropKit;
import com.jfinal.plugin.IPlugin;

/**
 * 读取Properties配置文件数据放入缓存
 * 
 * @author lijiasen@126.com
 */
public class PropertiesPlugin implements IPlugin {

	protected final Logger log = LoggerFactory.getLogger(getClass());

	/**
	 * 保存系统配置参数值
	 */
	private static Map<String, Object> paramMap = Maps.newHashMap();;

	private Properties properties;

	public PropertiesPlugin(Properties properties) {
		this.properties = properties;
	}

	/**
	 * 获取系统配置参数值
	 * 
	 * @param key
	 * @return
	 */
	public static Object getParamMapValue(String key) {
		return paramMap.get(key);
	}

	@Override
	public boolean start() {

		paramMap.put(DictKeys.SOLR_ADMIN_URL, properties.getProperty(DictKeys.SOLR_ADMIN_URL));

		paramMap.put(DictKeys.DB_TYPE_KEY, properties.getProperty(DictKeys.DB_TYPE_KEY).trim());

		// 判断数据库类型
		String db_type = (String) getParamMapValue(DictKeys.DB_TYPE_KEY);
		if (db_type.equals(DictKeys.DB_TYPE_POSTGRESQL)) { // pg 数据库连接信息
			initPostgreDBProperties();
		} else if (db_type.equals(DictKeys.DB_TYPE_MYSQL)) { // mysql 数据库连接信息
			initMySqlDBProperties();
		} else {
			initOracleDBProperties();
		}

		// 数据库连接池信息
		paramMap.put(DictKeys.DB_INITIALSIZE, properties.getProperty(DictKeys.DB_INITIALSIZE));
		paramMap.put(DictKeys.DB_MINIDLE, properties.getProperty(DictKeys.DB_MINIDLE));
		paramMap.put(DictKeys.DB_MAXACTIVE, properties.getProperty(DictKeys.DB_MAXACTIVE));
		paramMap.put(DictKeys.DB_MAXWAIT, properties.getProperty(DictKeys.DB_MAXWAIT));
		// paramMap.put(DictKeys.DB_FILTERS,
		// properties.getProperty(DictKeys.DB_FILTERS));
		// paramMap.put(DictKeys.DB_TIMEBETWEENCONNECTERRORMILLIS,
		// properties.getProperty(DictKeys.DB_TIMEBETWEENCONNECTERRORMILLIS));
		paramMap.put(DictKeys.DB_TIMEBETWEENEVICTIONRUNSMILLIS, properties.getProperty(DictKeys.DB_TIMEBETWEENEVICTIONRUNSMILLIS));
		paramMap.put(DictKeys.DB_MINEVICTABLEIDLETIMEMILLIS, properties.getProperty(DictKeys.DB_MINEVICTABLEIDLETIMEMILLIS));

		paramMap.put(DictKeys.DB_TESTWHILEIDLE, properties.getProperty(DictKeys.DB_TESTWHILEIDLE));
		paramMap.put(DictKeys.DB_TESTONBORROW, properties.getProperty(DictKeys.DB_TESTONBORROW));
		paramMap.put(DictKeys.DB_TESTONRETURN, properties.getProperty(DictKeys.DB_TESTONRETURN));
		paramMap.put(DictKeys.DB_REMOVEABANDONED, properties.getProperty(DictKeys.DB_REMOVEABANDONED));
		paramMap.put(DictKeys.DB_REMOVEABANDONEDTIMEOUTMILLIS, properties.getProperty(DictKeys.DB_REMOVEABANDONEDTIMEOUTMILLIS));
		// paramMap.put(DictKeys.DB_MAXPOOLPREPAREDSTATEMENTPERCONNECTIONSIZE,
		// properties.getProperty(DictKeys.DB_MAXPOOLPREPAREDSTATEMENTPERCONNECTIONSIZE));
		// paramMap.put(DictKeys.DB_LOGABANDONED,
		// properties.getProperty(DictKeys.DB_LOGABANDONED));
		paramMap.put(DictKeys.DB_JDBC_STAT, properties.getProperty(DictKeys.DB_JDBC_STAT));

		Properties properties = PropKit.use("domeke.properties", Const.DEFAULT_ENCODING).getProperties();

		// 把常用配置信息写入map
		String scan_package = properties.getProperty(DictKeys.CONFIG_SCAN_PACKAGE).trim();
		if (null != scan_package && !scan_package.isEmpty()) {
			List<String> list = new ArrayList<String>();
			String[] pkgs = scan_package.split(",");
			for (String pkg : pkgs) {
				list.add(pkg.trim());
			}
			paramMap.put(DictKeys.CONFIG_SCAN_PACKAGE, list);
		} else {
			paramMap.put(DictKeys.CONFIG_SCAN_PACKAGE, new ArrayList<String>());
		}

		String scan_jar = properties.getProperty(DictKeys.CONFIG_SCAN_JAR).trim();
		if (null != scan_jar && !scan_jar.isEmpty()) {
			List<String> list = new ArrayList<String>();
			String[] jars = scan_jar.split(",");
			for (String jar : jars) {
				list.add(jar.trim());
			}
			paramMap.put(DictKeys.CONFIG_SCAN_JAR, list);
		} else {
			paramMap.put(DictKeys.CONFIG_SCAN_JAR, new ArrayList<String>());
		}

		paramMap.put(DictKeys.CONFIG_DEVMODE, properties.getProperty(DictKeys.CONFIG_DEVMODE).trim());

		paramMap.put(DictKeys.CONFIG_LUCENEINDEX, properties.getProperty(DictKeys.CONFIG_LUCENEINDEX).trim());

		paramMap.put(DictKeys.CONFIG_SECURITYKEY_KEY, properties.getProperty(DictKeys.CONFIG_SECURITYKEY_KEY).trim());

		paramMap.put(DictKeys.CONFIG_PASSERRORCOUNT_KEY, Integer.valueOf(properties.getProperty(DictKeys.CONFIG_PASSERRORCOUNT_KEY)));

		paramMap.put(DictKeys.CONFIG_PASSERRORHOUR_KEY, Integer.valueOf(properties.getProperty(DictKeys.CONFIG_PASSERRORHOUR_KEY)));

		paramMap.put(DictKeys.CONFIG_MAXPOSTSIZE_KEY, Integer.valueOf(properties.getProperty(DictKeys.CONFIG_MAXPOSTSIZE_KEY)));

		paramMap.put(DictKeys.CONFIG_MAXAGE_KEY, Integer.valueOf(properties.getProperty(DictKeys.CONFIG_MAXAGE_KEY)));

		paramMap.put(DictKeys.CONFIG_DOMAIN_KEY, properties.getProperty(DictKeys.CONFIG_DOMAIN_KEY));

		// mail配置
		paramMap.put(DictKeys.CONFIG_MAIL_HOST, properties.getProperty(DictKeys.CONFIG_MAIL_HOST).trim());
		paramMap.put(DictKeys.CONFIG_MAIL_PORT, properties.getProperty(DictKeys.CONFIG_MAIL_PORT).trim());
		paramMap.put(DictKeys.CONFIG_MAIL_FROM, properties.getProperty(DictKeys.CONFIG_MAIL_FROM).trim());
		paramMap.put(DictKeys.CONFIG_MAIL_USERNAME, properties.getProperty(DictKeys.CONFIG_MAIL_USERNAME).trim());
		paramMap.put(DictKeys.CONFIG_MAIL_PASSWORD, properties.getProperty(DictKeys.CONFIG_MAIL_PASSWORD).trim());
		paramMap.put(DictKeys.CONFIG_MAIL_TO, properties.getProperty(DictKeys.CONFIG_MAIL_TO).trim());

		paramMap.put(DictKeys.UPLOAD_FILE_PATH, properties.getProperty(DictKeys.UPLOAD_FILE_PATH).trim());

		for (String key : paramMap.keySet()) {
			log.debug("全局参数配置：" + key + " = " + paramMap.get(key));
		}

		return true;
	}

	private void initMySqlDBProperties() {
		// 读取当前配置数据库连接信息
		paramMap.put(DictKeys.DB_CONNECTION_DRIVERCLASS, "com.mysql.jdbc.Driver");
		paramMap.put(DictKeys.DB_CONNECTION_JDBCURL, properties.getProperty("mysql.jdbc.url").trim());
		paramMap.put(DictKeys.DB_CONNECTION_USERNAME, properties.getProperty("mysql.jdbc.username").trim());
		paramMap.put(DictKeys.DB_CONNECTION_PASSWORD, properties.getProperty("mysql.jdbc.password").trim());

		paramMap.put(DictKeys.DB_VALIDATIONQUERY_MYSQL, properties.getProperty(DictKeys.DB_VALIDATIONQUERY_MYSQL));

		// 解析数据库连接URL，获取数据库名称
		String jdbcUrl = (String) getParamMapValue(DictKeys.DB_CONNECTION_JDBCURL);
		String database = jdbcUrl.substring(jdbcUrl.indexOf("//") + 2);
		database = database.substring(database.indexOf("/") + 1);

		// 解析数据库连接URL，获取数据库地址IP
		String ip = jdbcUrl.substring(jdbcUrl.indexOf("//") + 2);
		ip = ip.substring(0, ip.indexOf(":"));

		// 解析数据库连接URL，获取数据库地址端口
		String port = jdbcUrl.substring(jdbcUrl.indexOf("//") + 2);
		port = port.substring(port.indexOf(":") + 1, port.indexOf("/"));

		// 把数据库连接信息写入常用map
		paramMap.put(DictKeys.DB_CONNECTION_IP, ip);
		paramMap.put(DictKeys.DB_CONNECTION_PORT, port);
		paramMap.put(DictKeys.DB_CONNECTION_DBNAME, database);
	}

	private void initPostgreDBProperties() {
		// 读取当前配置数据库连接信息
		paramMap.put(DictKeys.DB_CONNECTION_DRIVERCLASS, properties.getProperty("postgresql.jdbc.driverClass").trim());
		paramMap.put(DictKeys.DB_CONNECTION_JDBCURL, properties.getProperty("postgresql.jdbc.url").trim());
		paramMap.put(DictKeys.DB_CONNECTION_USERNAME, properties.getProperty("postgresql.jdbc.username").trim());
		paramMap.put(DictKeys.DB_CONNECTION_PASSWORD, properties.getProperty("postgresql.jdbc.password").trim());

		// 解析数据库连接URL，获取数据库名称
		String jdbcUrl = (String) getParamMapValue(DictKeys.DB_CONNECTION_JDBCURL);
		String database = jdbcUrl.substring(jdbcUrl.indexOf("//") + 2);
		database = database.substring(database.indexOf("/") + 1);

		// 解析数据库连接URL，获取数据库地址IP
		String ip = jdbcUrl.substring(jdbcUrl.indexOf("//") + 2);
		ip = ip.substring(0, ip.indexOf(":"));

		// 解析数据库连接URL，获取数据库地址端口
		String port = jdbcUrl.substring(jdbcUrl.indexOf("//") + 2);
		port = port.substring(port.indexOf(":") + 1, port.indexOf("/"));

		// 把数据库连接信息写入常用map
		paramMap.put(DictKeys.DB_CONNECTION_IP, ip);
		paramMap.put(DictKeys.DB_CONNECTION_PORT, port);
		paramMap.put(DictKeys.DB_CONNECTION_DBNAME, database);
	}

	private void initOracleDBProperties() {
		// 读取当前配置数据库连接信息
		paramMap.put(DictKeys.DB_CONNECTION_DRIVERCLASS, properties.getProperty("oracle.jdbc.driverClass").trim());
		paramMap.put(DictKeys.DB_CONNECTION_JDBCURL, properties.getProperty("oracle.jdbc.url").trim());
		paramMap.put(DictKeys.DB_CONNECTION_USERNAME, properties.getProperty("oracle.jdbc.username").trim());
		paramMap.put(DictKeys.DB_CONNECTION_PASSWORD, properties.getProperty("oracle.jdbc.password").trim());
		paramMap.put(DictKeys.DB_VALIDATIONQUERY, properties.getProperty(DictKeys.DB_VALIDATIONQUERY_ORACLE));
	}

	@Override
	public boolean stop() {
		paramMap.clear();
		return true;
	}

	public static Map<String, Object> getParamMap() {
		return paramMap;
	}

}
