/**
 * 
 */
package com.domeke.core.render;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;

import net.sf.jxls.transformer.XLSTransformer;

import org.apache.poi.ss.usermodel.Workbook;

import com.google.common.collect.Maps;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;

/**
 * @author lijiasen
 * 
 * <pre>
 * </pre>
 */
public class ExcelRender extends Render {

	private static final String CONTENT_TYPE = "application/vnd.ms-excel;charset=" + getEncoding();

	// private static final String CONTENT_TYPE = "application/octet-stream";

	public static ExcelRender me(String templetFile) {
		return new ExcelRender(templetFile);
	}

	private Map<String, Object> beans = Maps.newHashMap();
	private String filename = "file1.xls";

	private String templetFile;

	public ExcelRender(String templetFile) {
		this.templetFile = templetFile;
	}

	public ExcelRender beans(Map<String, Object> beans) {
		this.beans = beans;
		return this;
	}

	private void buildBean() {
		Enumeration<String> attrs = request.getAttributeNames();
		while (attrs.hasMoreElements()) {
			String key = attrs.nextElement();
			Object value = request.getAttribute(key);
			beans.put(key, value);
		}

	}

	public ExcelRender filename(String filename) {
		this.filename = filename;
		return this;
	}

	@Override
	public void render() {
		if (beans.isEmpty()) {
			buildBean();
		}
		response.setContentType(CONTENT_TYPE);
		response.setHeader("Content-Disposition", "attachment;Filename=" + filename);
		OutputStream out = null;
		InputStream is = null;
		Workbook workBook = null;
		try {
			out = response.getOutputStream();
			is = new BufferedInputStream(new FileInputStream(templetFile));
			XLSTransformer transformer = new XLSTransformer();
			workBook = transformer.transformXLS(is, beans);
			workBook.write(out);

		} catch (Exception e) {
			e.printStackTrace();
			throw new RenderException(e);
		} finally {
			try {
				if (out != null) {
					out.close();
				}
				if (is != null) {
					is.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

	}

	public ExcelRender templetFile(String templetFile) {
		this.templetFile = templetFile;
		return this;
	}

}
