package com.domeke.core.service;

import java.util.LinkedList;
import java.util.Map;

import com.domeke.core.db.sql.SqlKit;
import com.domeke.core.model.BaseModel;
import com.jfinal.plugin.activerecord.Model;

public abstract class BaseService {

	public void save(Model<?> model) {
		model.save();
	}

	public void update(Model<?> model) {
		model.update();
	}

	/**
	 * 获取SQL，固定SQL
	 * 
	 * @param sqlId
	 * @return
	 */
	protected String getSql(String sqlId) {
		return SqlKit.getSql(sqlId);
	}

	/**
	 * 获取SQL，动态SQL
	 * 
	 * @param sqlId
	 * @param param
	 * @return
	 */
	protected String getSql(String sqlId, Map<String, Object> param) {
		return SqlKit.getSql(sqlId, param);
	}

	/**
	 * 获取SQL，动态SQL
	 * 
	 * @param sqlId
	 * @param param
	 *            查询参数
	 * @param list
	 *            用于接收预处理的值
	 * @return
	 */
	protected String getSql(String sqlId, Map<String, String> param, LinkedList<Object> list) {
		return SqlKit.getSql(sqlId, param, list);
	}

	/**
	 * 把11,22,33...转成'11','22','33'...
	 * 
	 * @param ids
	 * @return
	 */
	protected String toSql(String ids) {
		if (null == ids || ids.trim().isEmpty()) {
			return null;
		}

		String[] idsArr = ids.split(",");
		StringBuilder sqlSb = new StringBuilder();
		int length = idsArr.length;
		for (int i = 0, size = length - 1; i < size; i++) {
			sqlSb.append(" '").append(idsArr[i]).append("', ");
		}
		if (length != 0) {
			sqlSb.append(" '").append(idsArr[length - 1]).append("' ");
		}

		return sqlSb.toString();
	}

	/**
	 * 把数组转成'11','22','33'...
	 * 
	 * @param ids
	 * @return
	 */
	protected String toSql(String[] idsArr) {
		if (idsArr == null || idsArr.length == 0) {
			return null;
		}

		StringBuilder sqlSb = new StringBuilder();
		int length = idsArr.length;
		for (int i = 0, size = length - 1; i < size; i++) {
			sqlSb.append(" '").append(idsArr[i]).append("', ");
		}
		if (length != 0) {
			sqlSb.append(" '").append(idsArr[length - 1]).append("' ");
		}

		return sqlSb.toString();
	}
	
	public void update(BaseModel<?> model) {
		model.update();
	}
	
	public void save(BaseModel<?> model){
		model.save();
	}
	
	public void delete(BaseModel<?> model){
		model.delete();
	}

}
