/**
 * 
 */
package com.domeke.core.service;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.domeke.core.base.config.DictKeys;
import com.domeke.core.service.cache.ICacheService;
import com.google.common.collect.Lists;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.ehcache.CacheKit;

/**
 * @author lijiasen
 * 
 * <pre>
 * </pre>
 */
public class CodeService extends BaseService implements ICacheService {

	private Logger logger = LoggerFactory.getLogger(CodeService.class);

	private static Map<String, Record> codeTableMap;

	private static Map<String, Map<String, Record>> codeTypeMap;

	@Override
	public void cacheAll() {
		cacheCode();
		cacheCodeList();
	}

	private void cacheCode() {
		String sql = getSql("domeke.core.codeTable.queryCodeTabeList");

		List<Record> list = Db.find(sql);

		logger.info("cache code start ====");
		logger.info("cache code size {}====", list.size());
		String cacheKey = "";
		String codeType = "";
		String codeKey = "";
		for (Record codeTable : list) {
			codeType = codeTable.get("CODETYPE");
			codeKey = codeTable.get("CODEKEY");
			cacheKey = codeType + "_" + codeKey;
			CacheKit.put(DictKeys.CACHE_NAME_SYSTEM, CACHESTART_DICT + cacheKey.toUpperCase(), codeTable.getStr("codevalue"));
			CacheKit.put(DictKeys.CACHE_NAME_SYSTEM, CACHESTART_DICT_NAME + cacheKey.toUpperCase(), codeTable.getStr("codevalue"));

		}

		logger.info("cache code end ====");
	}

	public void cacheCodeList() {
		String sql = getSql("domeke.core.codetype.quertAllCodeType");
		List<Record> codeTypelist = Db.find(sql);
		sql = getSql("domeke.core.codeTable.queryCodeTabeList");
		List<Record> codeTablelist = Db.find(sql);
		List<Record> cacheList = Lists.newArrayList();
		String type = "";
		for (Record codeType : codeTypelist) {
			cacheList = Lists.newArrayList();
			type = codeType.get("codetype");
			for (Record codeTable : codeTablelist) {
				if (type.equals(codeTable.get("codetype"))) {
					cacheList.add(codeTable);
				}
			}
			CacheKit.put(DictKeys.CACHE_NAME_SYSTEM, CACHESTART_DICT_LIST + type, cacheList);
			logger.info("cache codeType {} list {} end ====", type, cacheList.size());

		}
	}

	@Override
	public void removeCache() {
	}

	@Override
	public void removeCache(String cacheKey) {
	}

	@Override
	public <T> T getCache(String cacheKey) {
		return CacheKit.get(DictKeys.CACHE_NAME_SYSTEM, cacheKey);
	}
}
