package com.domeke.core.service;

import java.util.List;
import java.util.Map;

import com.domeke.core.model.CodeTable;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Page;

public class CodeTableService extends BaseService {

	public static final CodeTableService SERVICE = new CodeTableService();

	/**
	 * 查询所有码表
	 * 
	 * @return
	 */
	public List<CodeTable> queryAllCodeTable() {
		return CodeTable.dao.find(getSql("domeke.core.codeTable.quertAllCodeTable"));
	}

	/**
	 * 根据码表名称与码表查询
	 * 
	 * @param params
	 *            码表名称与码表类型
	 * @return
	 */
	public Page<CodeTable> queryCodeTableList(int pageNumber, Map<String, Object> params) {
		return CodeTable.dao.queryCodeTableList(pageNumber, params);
	}

	/**
	 * 根据码表ID查询
	 * 
	 * @param codeTypeId
	 *            码表ID
	 * @return
	 */
	public CodeTable queryCodeTableById(String codeTableId) {
		return CodeTable.dao.findById(codeTableId);
	}

	/**
	 * 根据码表ID删除，支持批量删除
	 * 
	 * @param codeTypeId
	 *            码表ID
	 * @return
	 */
	public void deleteCodeTableById(String codeTableId) {
		String[] codeTableIds = new String[] {};
		if (!StrKit.isBlank(codeTableId)) {
			codeTableIds = codeTableId.split(",");
		}
		for (int i = 0; i < codeTableIds.length; i++) {
			CodeTable.dao.deleteById(codeTableIds[i]);
		}
	}

	public List<String> queryCodeTypeList() {
		String sql = getSql("domeke.core.codetype.queryCodeTypeList");
		List<String> codeTypeList = Db.query(sql);
		return codeTypeList;
	}
}
