package com.domeke.core.service;

import java.util.List;
import java.util.Map;

import com.domeke.core.model.CodeType;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.Page;

/**
 * 
 * @author zhouying
 *
 */
public class CodeTypeService extends BaseService {

	public static final CodeTypeService SERVICE = new CodeTypeService();

	/**
	 * 查询所有码表类型
	 * 
	 * @return
	 */
	public List<CodeType> queryAllCodeType() {
		return CodeType.codeTypeDao.find(getSql("domeke.core.codetype.quertAllCodeType"));
	}

	/**
	 * 根据码表类型名称与码表类型查询
	 * 
	 * @param params
	 *            码表类型名称与码表类型
	 * @return
	 */
	public Page<CodeType> queryCodeTypeList(int pageNumber, Map<String, Object> params) {
		return CodeType.codeTypeDao.queryCodeTypeList(pageNumber, params);
	}

	/**
	 * 根据码表类型ID查询
	 * 
	 * @param codeTypeId
	 *            码表类型ID
	 * @return
	 */
	public CodeType queryCodeTypeById(String codeTypeId) {
		return CodeType.codeTypeDao.findById(codeTypeId);
	}

	/**
	 * 根据码表类型ID删除，支持批量删除
	 * 
	 * @param codeTypeId
	 *            码表类型ID
	 * @return
	 */
	public void deleteCodeTypeById(String codeTypeId) {
		String[] codeTypeIds = new String[] {};
		if (!StrKit.isBlank(codeTypeId)) {
			codeTypeIds = codeTypeId.split(",");
		}
		for (int i = 0; i < codeTypeIds.length; i++) {
			CodeType.codeTypeDao.deleteById(codeTypeIds[i]);
		}
	}
}
