package com.domeke.core.service;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.domeke.core.model.Company;
import com.domeke.core.service.cache.ICacheService;
import com.jfinal.plugin.activerecord.Page;

/**
 * 公司service
 * 
 * @author Administrator
 *
 */
public class CompanyService extends BaseService implements ICacheService {

	private static final Logger logger = LoggerFactory.getLogger(CompanyService.class);

	public static final CompanyService SERVICE = new CompanyService();

	public List<Company> queryAllCompany() {
		return Company.dao.find(getSql("domeke.core.company.queryAll"));
	}

	public List<Company> queryParentCompany() {
		return Company.dao.find(getSql("domeke.core.company.queryParentCompany"));
	}

	public List<Company> queryByFilter(Map<String, Object> filter) {
		return Company.dao.find(getSql("domeke.core.company.queryByFilter", filter));
	}

	@Override
	public void cacheAll() {
		// TODO Auto-generated method stub
	}

	@Override
	public void removeCache() {
		// TODO Auto-generated method stub
	}

	@Override
	public void removeCache(String cacheKey) {
		// TODO Auto-generated method stub
	}

	@Override
	public <T> T getCache(String cacheKey) {
		// TODO Auto-generated method stub
		return null;
	}

	public Page<Company> queryCompanyList(int pageNumber, Map<String, Object> filter) {
		return Company.dao.queryCompanyList(pageNumber, filter);
	}

	public int checkName(String companyname) {
		return Company.dao.checkName(companyname);
	}
}
