package com.domeke.core.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.domeke.core.base.config.DictKeys;
import com.domeke.core.model.District;
import com.domeke.core.service.cache.ICacheService;
import com.google.common.collect.Lists;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.ehcache.CacheKit;

public class DistrictAreaService implements ICacheService {

	private Logger logger = LoggerFactory.getLogger(DistrictAreaService.class);

	public void cacheAll() {
		cacheAreaList();
		cacheArea();
	}

	public void removeCache() {
	}

	public void removeCache(String cacheKey) {
	}

	public <T> T getCache(String cacheKey) {
		return null;
	}

	private void cacheAreaList() {

		List<Record> allCityList = District.dao.getCityList();
		List<Record> areaList = Lists.newArrayList();

		List<Record> AllAreaList = District.dao.getAreaList();

		for (Record record : allCityList) {
			areaList = Lists.newArrayList();
			String cityKey = record.getStr("codeKey");
			for (Record cityRecord : AllAreaList) {
				String parentid = cityRecord.getStr("parentid");
				if (cityKey.equalsIgnoreCase(parentid)) {
					areaList.add(cityRecord);
				}
			}
			CacheKit.put(DictKeys.CACHE_NAME_SYSTEM, CACHESTART_DISTRICT_AREA_LIST + cityKey, areaList);
			logger.info("缓存加载：{} Area end  cache size{} ", record.getStr("SHORTNAME"), areaList.size());
		}

	}

	private void cacheArea() {
		List<Record> areaList = District.dao.getAreaList();
		for (Record record : areaList) {
			String codekey = record.getStr("codekey");
			CacheKit.put(DictKeys.CACHE_NAME_SYSTEM, CACHESTART_DISTRICT_AREA + codekey, record);
		}
		logger.info("缓存加载：Area end  cache size {} ", areaList.size());
	}

}
