package com.domeke.core.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.domeke.core.base.config.DictKeys;
import com.domeke.core.model.District;
import com.domeke.core.service.cache.ICacheService;
import com.google.common.collect.Lists;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.ehcache.CacheKit;

public class DistrictCityService implements ICacheService {

	private Logger logger = LoggerFactory.getLogger(DistrictCityService.class);

	public void cacheAll() {
		cacheCityList();
		cacheCity();
	}

	public void removeCache() {
	}

	public void removeCache(String cacheKey) {
	}

	public <T> T getCache(String cacheKey) {
		return null;
	}

	private void cacheCity() {
		List<Record> cityList = District.dao.getCityList();
		for (Record record : cityList) {
			String codekey = record.getStr("codekey");
			CacheKit.put(DictKeys.CACHE_NAME_SYSTEM, CACHESTART_DISTRICT_CITY + codekey, record);
		}
		logger.info("缓存加载：City end  cache size{} ", cityList.size());
	}

	private void cacheCityList() {

		List<Record> allCityList = District.dao.getCityList();
		List<Record> cityList = Lists.newArrayList();
		List<Record> provinceList = District.dao.getProvinceList();

		for (Record record : provinceList) {
			cityList = Lists.newArrayList();
			String provinceKey = record.getStr("codeKey");
			for (Record cityRecord : allCityList) {
				String parentid = cityRecord.getStr("parentid");
				if (provinceKey.equalsIgnoreCase(parentid)) {
					cityList.add(cityRecord);
				}
			}
			CacheKit.put(DictKeys.CACHE_NAME_SYSTEM, CACHESTART_DISTRICT_CITY_LIST + provinceKey, cityList);
			logger.info("缓存加载：{} CityList end  cache size{} ", record.getStr("SHORTNAME"), cityList.size());
		}

	}

}
