package com.domeke.core.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.domeke.core.base.config.DictKeys;
import com.domeke.core.model.District;
import com.domeke.core.service.cache.ICacheService;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.ehcache.CacheKit;

public class DistrictService implements ICacheService {

	private Logger logger = LoggerFactory.getLogger(DistrictService.class);

	public void cacheAll() {
		cacheProvinceList();
		cacheProvince();
		cacheDistrict();
	}

	public void removeCache() {
	}

	public void removeCache(String cacheKey) {
	}

	@SuppressWarnings("unchecked")
	public District getCache(String cacheKey) {
		return CacheKit.get(DictKeys.CACHE_NAME_SYSTEM, cacheKey);
	}

	public void cacheProvince() {
		List<Record> provinceList = District.dao.getProvinceList();
		logger.info("缓存加载：Province start");
		for (Record record : provinceList) {
			String codekey = record.getStr("codekey");
			CacheKit.put(DictKeys.CACHE_NAME_SYSTEM, CACHESTART_DISTRICT_PROVINCE + codekey, record);
		}
		logger.info("缓存加载：Province end  cache size {} ", provinceList.size());
	}

	public void cacheProvinceList() {
		List<Record> provinceList = District.dao.getProvinceList();
		CacheKit.put(DictKeys.CACHE_NAME_SYSTEM, CACHESTART_DISTRICT_PROVINCE_LIST, provinceList);
		logger.info("缓存加载：Province end  cache size {} ", provinceList.size());
	}

	public void cacheDistrict() {
		List<Record> provinceList = District.dao.getAll();

		for (Record record : provinceList) {
			String codekey = record.getStr("codekey");
			CacheKit.put(DictKeys.CACHE_NAME_SYSTEM, CACHESTART_DISTRICT + codekey, record);
		}

	}

}
