package com.domeke.core.service;

import java.util.List;
import java.util.Map;

import com.domeke.core.model.Emailconfig;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.Page;

public class EmailconfigService extends BaseService {
	public static final EmailconfigService SERVICE = new EmailconfigService();

	/**
	 * 查询所有邮件账户
	 * 
	 * @return
	 */
	public List<Emailconfig> queryAllEmailconfig() {
		return Emailconfig.dao.find(getSql("domeke.core.emailconfig.queryAllEmailconfig"));
	}

	/**
	 * 根据邮件账户ID删除邮件账户
	 * 
	 * @param configId
	 *            邮件账户ID
	 */
	public void deleteEmailconfigById(String configId) {
		String[] configIds = new String[] {};
		if (!StrKit.isBlank(configId)) {
			configIds = configId.split(",");
		}
		for (int i = 0; i < configIds.length; i++) {
			Emailconfig.dao.deleteById(configIds[i]);
		}
	}

	/**
	 * 根据参数查找邮件账户
	 * 
	 * @param params
	 * @return
	 */
	public Page<Emailconfig> queryEmailconfigByParams(int pageNumber, Map<String, Object> params) {
		return Emailconfig.dao.queryEmailconfigList(pageNumber, params);
	}
}
