/**
 * 
 */
package com.domeke.core.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.domeke.core.base.config.DictKeys;
import com.domeke.core.model.Menu;
import com.domeke.core.service.cache.ICacheService;
import com.google.common.collect.Lists;
import com.jfinal.plugin.ehcache.CacheKit;

/**
 * @author lijiasen
 * 
 * <pre>
 * </pre>
 */
public class MenuService extends BaseService implements ICacheService {

	public static final MenuService SERVICE = new MenuService();

	private Logger logger = LoggerFactory.getLogger(MenuService.class);

	@Override
	public void cacheAll() {
		cacheAdminMenu();
	}

	/**
	 * 缓存后台管理菜单
	 */
	private void cacheAdminMenu() {
		logger.info("缓存加载：Menu start");
		String sql = getSql("domeke.core.menu.queryMenuByModuleId");
		List<Menu> menuList = Menu.dao.find(sql, 1);
		logger.info("admin menu list size = {}", menuList.size());

		CacheKit.put(DictKeys.CACHE_NAME_SYSTEM, CACHESTART_ADMIN_MENU, menuList);
		List<Menu> childMenuList = Lists.newArrayList();
		for (Menu menu : menuList) {
			sql = getSql("domeke.core.menu.queryMenuChild");
			childMenuList = Menu.dao.find(sql, menu.getPKValue());
			CacheKit.put(DictKeys.CACHE_NAME_SYSTEM, CACHESTART_ADMIN_MENU + menu.getPKValue(), childMenuList);
		}

		logger.info("缓存加载：Menu end, size = " + menuList.size());
	}

	/**
	 * 删除缓存
	 */
	public void removeCache(String cachekey) {
		CacheKit.remove(DictKeys.CACHE_NAME_SYSTEM, cachekey);
		CacheKit.remove(DictKeys.CACHE_NAME_SYSTEM, cachekey);
	}

	/**
	 * 获取缓存
	 * 
	 * @param ids
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public Menu getCache(String cacheName) {
		Menu menu = CacheKit.get(DictKeys.CACHE_NAME_SYSTEM, cacheName);
		return menu;
	}

	@Override
	public void removeCache() {
		CacheKit.remove(DictKeys.CACHE_NAME_SYSTEM, CACHESTART_ADMIN_MENU);
		CacheKit.remove(DictKeys.CACHE_NAME_SYSTEM, CACHESTART_INDEX_MENU);
	}

	public Menu queryMenuById(String id) {
		Menu menu = Menu.dao.findById(id);
		return menu;
	}

	public List<Menu> queryMenuChild(String id) {
		String sql = getSql("domeke.core.menu.queryMenuChild");
		List<Menu> menuList = Menu.dao.find(sql, id);
		return menuList;
	}

	public List<Menu> queryMenuParent() {
		String sql = getSql("domeke.core.menu.queryMenuParent");
		List<Menu> menuList = Menu.dao.find(sql);
		return menuList;
	}

	public List<Menu> queryAllMenu() {
		String sql = getSql("domeke.core.menu.queryAllMenu");
		List<Menu> menuList = Menu.dao.find(sql);
		return menuList;
	}

	public Object queryMenuTree() {
		List<Menu> menuList = queryAllMenu();
		List<Menu> menuParent = queryMenuParent();
		int i = 0;
		for (Menu menu : menuParent) {
			if (i == 0) {
				returnStr.setLength(0);
			}
			recursionFn(menuList, menu);
			i++;
		}
		Object menuJson = modifyStr(returnStr.toString());
		return menuJson;
	}

	public Menu recursiveTree(String menuId) {
		Menu menu = queryMenuById(menuId);
		List<Menu> childTreeNodes = queryMenuChild(menuId);
		// 遍历子节点
		for (Menu child : childTreeNodes) {
			Menu m = recursiveTree(child.getStr("menuid")); // 递归
			menu = m;
		}
		return menu;
	}

	StringBuffer returnStr = new StringBuffer();

	public void recursionFn(List<Menu> list, Menu node) {
		if (hasChild(list, node)) {
			returnStr.append("{id:");
			returnStr.append("'" + node.getStr("menuid") + "'");
			returnStr.append(",name:");
			returnStr.append("'" + node.getStr("menuname") + "'");
			returnStr.append(",parent:");
			returnStr.append("'" + node.getStr("parentmenuid") + "'");
			returnStr.append(",childrens:[");
			List<Menu> childList = getChildList(list, node);
			Iterator<Menu> it = childList.iterator();
			while (it.hasNext()) {
				Menu n = (Menu) it.next();
				recursionFn(list, n);
			}
			returnStr.append("]},");
		} else {
			returnStr.append("{id:");
			returnStr.append("'" + node.getStr("menuid") + "'");
			returnStr.append(",name:");
			returnStr.append("'" + node.getStr("menuname") + "'");
			returnStr.append("},");
		}

	}

	public boolean hasChild(List<Menu> list, Menu node) { // 判断是否有子节点
		return getChildList(list, node).size() > 0 ? true : false;
	}

	public List<Menu> getChildList(List<Menu> list, Menu node) { // 得到子节点列表
		List<Menu> li = new ArrayList<Menu>();
		Iterator<Menu> it = list.iterator();
		while (it.hasNext()) {
			Menu n = (Menu) it.next();
			if (node.getStr("menuid").equals(n.getStr("parentmenuid"))) {
				li.add(n);
			}
		}
		return li;
	}

	public String modifyStr(String returnStr) {// 修饰一下才能满足Extjs的Json格式
		return ("[" + returnStr + "]").replaceAll(",]", "]");
	}

}
