package com.domeke.core.service;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.domeke.core.model.Module;
import com.domeke.core.service.cache.ICacheService;
import com.jfinal.plugin.activerecord.Page;

/**
 * 模块service
 * 
 * @author Administrator
 *
 */
public class ModuleService extends BaseService implements ICacheService {

	private static final Logger logger = LoggerFactory.getLogger(ModuleService.class);

	public static final ModuleService SERVICE = new ModuleService();

	public List<Module> queryAllModule() {
		return Module.dao.find(getSql("domeke.core.module.queryAll"));
	}

	public List<Module> queryByFilter(Map<String, Object> filter) {
		return Module.dao.find(getSql("domeke.core.module.queryByFilter", filter));
	}

	public List<Module> queryParentModule() {
		return Module.dao.find(getSql("domeke.core.module.queryParentModule"));
	}

	public List<Module> queryModuleCodedata() {
		return Module.dao.find(getSql("domeke.core.module.queryModuleCodedata"));
	}

	@Override
	public void cacheAll() {
	}

	@Override
	public void removeCache() {
	}

	@Override
	public void removeCache(String cacheKey) {
	}

	@Override
	public <T> T getCache(String cacheKey) {
		return null;
	}

	public Page<Module> queryModuleList(int pageNumber, Map<String, Object> filter) {
		return Module.dao.queryModuleList(pageNumber, filter);
	}

}
