package com.domeke.core.service;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.domeke.core.model.Operator;
import com.jfinal.plugin.activerecord.Page;

/**
 * 权限service
 * 
 * @author Administrator
 *
 */
public class OperatorService extends BaseService {

	private static final Logger logger = LoggerFactory.getLogger(OperatorService.class);

	public static final OperatorService SERVICE = new OperatorService();

	public List<Operator> queryAllOperator() {
		return Operator.dao.find(getSql("domeke.core.operator.queryAll"));
	}

	public List<Operator> queryByFilter(Map<String, Object> filter) {
		return Operator.dao.find(getSql("domeke.core.operator.queryByFilter", filter));
	}

	public Page<Operator> queryOperatorList(int pageNumber, Map<String, Object> filter) {
		return Operator.dao.queryOperatorList(pageNumber, filter);
	}

}
