package com.domeke.core.service;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.domeke.core.model.Role;
import com.domeke.core.service.cache.ICacheService;
import com.jfinal.plugin.activerecord.Page;

/**
 * 角色service
 * 
 * @author Administrator
 *
 */
public class RoleService extends BaseService implements ICacheService {

	private static final Logger logger = LoggerFactory.getLogger(RoleService.class);

	public static final RoleService SERVICE = new RoleService();

	public List<Role> queryAllRole() {
		return Role.dao.find(getSql("domeke.core.role.queryAll"));
	}

	/**
	 * 获取角色信息
	 * 
	 * @param roleId
	 * @return
	 */
	public Role query(Object roleId) {
		return Role.dao.findById(roleId);
	}

	public List<Role> queryByFilter(Map<String, Object> filter) {
		return Role.dao.find(getSql("domeke.core.role.queryByFilter", filter));
	}

	public List<Role> queryRoleIdNameList() {
		return Role.dao.find(getSql("domeke.core.role.queryRoleIdNameList"));
	}

	@Override
	public void cacheAll() {
		// TODO Auto-generated method stub
	}

	@Override
	public void removeCache() {
		// TODO Auto-generated method stub
	}

	@Override
	public void removeCache(String cacheKey) {
		// TODO Auto-generated method stub
	}

	@Override
	public <T> T getCache(String cacheKey) {
		// TODO Auto-generated method stub
		return null;
	}

	public Page<Role> queryRoleList(int pageNumber, Map<String, Object> filter) {
		return Role.dao.queryRoleList(pageNumber, filter);
	}

	public int checkName(String rolename) {
		return Role.dao.checkName(rolename);
	}

}
