package com.domeke.core.service;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.domeke.core.model.UserRole;
import com.domeke.core.service.cache.ICacheService;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;

/**
 * 用户角色sevice
 * 
 * @author Administrator
 *
 */
public class UserRoleService extends BaseService implements ICacheService {

	private static final Logger logger = LoggerFactory.getLogger(UserService.class);

	public static final UserRoleService SERVICE = new UserRoleService();

	public List<Record> queryAllUserRole() {
		String sql = getSql("domeke.core.userRole.queryAll");
		List<Record> list = Db.find(sql);
		return list;
		// UserRole.dao.find(getSql("domeke.core.userRole.queryAll"));
	}

	public List<Record> queryByFilter(Map<String, Object> filter) {
		return Db.find(getSql("domeke.core.userRole.queryByFilter", filter));
		// return UserRole.dao.find(getSql("domeke.core.userRole.queryByFilter", filter));
	}

	/**
	 * 保存用户角色信息
	 * 
	 * @param userRole
	 */
	public void save(UserRole userRole) {
		userRole.save();
	}

	public void update(UserRole userRole) {
		userRole.update();
	}

	@Override
	public void cacheAll() {
		// TODO Auto-generated method stub

	}

	@Override
	public void removeCache() {
		// TODO Auto-generated method stub

	}

	@Override
	public void removeCache(String cacheKey) {
		// TODO Auto-generated method stub

	}

	@Override
	public UserRole getCache(String cacheKey) {
		// TODO Auto-generated method stub
		return null;
	}

	public Page<Record> queryUserRoleList(int pageNumber, Map<String, Object> filter) {
		return UserRole.dao.queryUserRoleList(pageNumber, filter);
	}

	public String checkUserRole(String userId, String roleId) {
		UserRole userRole = UserRole.dao.queryUserRole(userId, roleId);
		if (userRole != null)
			return "用户与角色重复";
		return null;
	}

}
