package com.domeke.core.thread;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.domeke.core.model.Syslog;

/**
 * 操作日志入库处理
 */
public class ThreadSysLog {

	private static Logger log = LoggerFactory.getLogger(ThreadSysLog.class);

	private static final int queueSize = 5000; // 入库队列大小
	private static boolean threadRun = true; // 线程是否运行

	/**
	 * 队列
	 */
	private static Queue<Syslog> queue = new ConcurrentLinkedQueue<Syslog>(); // 此队列按照
																				// FIFO（先进先出）原则对元素进行排序

	public static void setThreadRun(boolean threadRun) {
		ThreadSysLog.threadRun = threadRun;
	}

	/**
	 * 向队列中增加Syslog对象，基于ConcurrentLinkedQueue
	 * 
	 * @param syslog
	 */
	public static void add(Syslog syslog) {
		if (null != syslog) { // 此队列不允许使用 null 元素
			synchronized (queue) {
				if (queue.size() <= queueSize) {
					queue.offer(syslog);
				} else {
					queue.poll(); // 获取并移除此队列的头，如果此队列为空，则返回 null
					queue.offer(syslog); // 将指定元素插入此队列的尾部
					log.error("日志队列：超过" + queueSize);
				}
			}
		}
	}

	/**
	 * 获取Syslog对象，基于ConcurrentLinkedQueue
	 * 
	 * @return
	 */
	public static Syslog getSyslog() {
		synchronized (queue) {
			if (queue.isEmpty()) {
				return null;
			} else {
				return queue.poll(); // 获取并移除此队列的头，如果此队列为空，则返回 null
			}
		}
	}

	/**
	 * 启动入库线程
	 */
	public static void startSaveDBThread() {
		try {
			for (int i = 0; i < 10; i++) {
				Thread insertDbThread = new Thread(new Runnable() {
					public void run() {
						while (threadRun) {
							try {
								// 取队列数据
								Syslog sysLog = getSyslog();
								if (null == sysLog) {
									Thread.sleep(200);
								} else {
									sysLog.save();// 日志入库
								}
							} catch (Exception e) {
								log.error("保存操作日志到数据库异常");
								e.printStackTrace();
								throw new RuntimeException("ThreadSysLog -> save Exception");
							}
						}
					}
				});

				insertDbThread.setName("domeke-Thread-SysLog-insertDB-" + (i + 1));
				insertDbThread.start();
			}
		} catch (Exception e) {
			throw new RuntimeException("ThreadSysLog new Thread Exception");
		}
	}

}
