/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.db.sql;

import com.domeke.core.db.sql.SqlItem;
import com.domeke.core.db.sql.SqlStatement;
import com.domeke.core.kit.JaxbKit;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.activerecord.Table;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.beetl.core.BeetlKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.FileCopyUtils;

public class SqlKit {
    protected static final Logger logger = LoggerFactory.getLogger(SqlKit.class);
    private static final Map<String, String> sqlMap = new HashMap<String, String>();
    private static final List<String> badKeyWordList = new ArrayList<String>();

    public static boolean keywordVali(String queryStr) {
        queryStr = queryStr.toLowerCase();
        for (String badKeyWord : badKeyWordList) {
            if (queryStr.indexOf(badKeyWord) < 0) continue;
            return true;
        }
        return false;
    }

    public static String getSql(String sqlId) {
        String sql = sqlMap.get(sqlId);
        if (null == sql || sql.isEmpty()) {
            logger.error("sql\u8bed\u53e5\u4e0d\u5b58\u5728\uff1asql id\u662f" + sqlId);
        }
        return sql.replaceAll("[\\s]{2,}", " ");
    }

    public static String getSql(String sqlId, Map<String, Object> param) {
        String sqlTemplete = sqlMap.get(sqlId);
        if (null == sqlTemplete || sqlTemplete.isEmpty()) {
            logger.error("sql\u8bed\u53e5\u4e0d\u5b58\u5728\uff1asql id\u662f" + sqlId);
        }
        String sql = BeetlKit.render((String)sqlTemplete, param);
        Set<String> keySet = param.keySet();
        for (String key : keySet) {
            if (param.get(key) == null) continue;
            String value = (String)param.get(key);
            value = value.replace("'", "").replace(";", "").replace("--", "");
            sql = sql.replace("#" + key + "#", value);
        }
        return sql.replaceAll("[\\s]{2,}", " ");
    }

    public static String getSql(String sqlId, Map<String, String> param, LinkedList<Object> list) {
        String sqlTemplete = sqlMap.get(sqlId);
        if (null == sqlTemplete || sqlTemplete.isEmpty()) {
            logger.error("sql\u8bed\u53e5\u4e0d\u5b58\u5728\uff1asql id\u662f" + sqlId);
        }
        HashMap paramMap = Maps.newHashMap();
        Set<String> paramKeySet = param.keySet();
        for (String paramKey : paramKeySet) {
            paramMap.put(paramKey, param.get(paramKey));
        }
        String sql = BeetlKit.render((String)sqlTemplete, (Map)paramMap);
        Pattern pattern = Pattern.compile("#[\\w\\d\\$\\'\\%\\_]+#");
        Pattern pattern2 = Pattern.compile("\\$[\\w\\d\\_]+\\$");
        Matcher matcher = pattern.matcher(sql);
        while (matcher.find()) {
            String val;
            String clounm = matcher.group(0);
            Matcher matcher2 = pattern2.matcher(clounm);
            matcher2.find();
            String clounm2 = matcher2.group(0);
            String clounm3 = clounm2.replace("$", "");
            if (clounm.equals("#" + clounm2 + "#")) {
                val = param.get(clounm3);
                try {
                    Integer.parseInt(val);
                    sql = sql.replace(clounm, val);
                    continue;
                }
                catch (NumberFormatException e) {
                    logger.error("\u67e5\u8be2\u53c2\u6570\u503c\u9519\u8bef\uff0c\u6574\u578b\u503c\u4f20\u5165\u4e86\u5b57\u7b26\u4e32\uff0c\u975e\u6cd5\u5b57\u7b26\u4e32\u662f\uff1a" + val);
                    return null;
                }
            }
            val = param.get(clounm3);
            String clounm4 = clounm.replace("#", "").replace("'", "").replace(clounm2, val);
            list.add(clounm4);
            sql = sql.replace(clounm, "?");
        }
        return sql.replaceAll("[\\s]{2,}", " ");
    }

    public static void destory() {
        sqlMap.clear();
    }

    public static synchronized void init(boolean isInit) {
        Long startTime = System.currentTimeMillis();
        SqlKit.getResourceInJar();
        File file = new File(PathKit.getRootClassPath());
        ArrayList<File> files = new ArrayList<File>();
        try {
            SqlKit.listFiles(file, files);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String key = "";
        String sql = "";
        SqlStatement group = null;
        for (File xmlfile : files) {
            group = JaxbKit.unmarshal(xmlfile, SqlStatement.class);
            String filename = xmlfile.getName();
            String namespace = group.namespace;
            if (namespace == null || namespace.trim().equals("")) {
                namespace = xmlfile.getName();
            }
            for (SqlItem sqlItem : group.sqlItems) {
                key = namespace + "." + sqlItem.id;
                sql = sqlItem.value;
                sqlMap.put(key, sql);
            }
            if (null == namespace || namespace.trim().isEmpty()) {
                logger.error("sql xml\u6587\u4ef6" + filename + "\u7684\u547d\u540d\u7a7a\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            sql = sql.replaceAll("[\\s]{2,}", " ");
            sqlMap.put(key, sql);
            logger.debug("sql\u52a0\u8f7d, sql file = " + filename + ", sql key = " + key + ", sql content = " + sql);
        }
        long endTime = System.currentTimeMillis();
        logger.debug("\u521d\u59cb\u5316 SQL \u6587\u4ef6\u8017\u65f6  =" + (endTime - startTime));
    }

    public static Object[] filterDataStateParams(Object ... paras) {
        ArrayList list = Lists.newArrayList();
        if (paras.length > 0) {
            // empty if block
        }
        for (int i = 0; i < paras.length; ++i) {
            list.add(paras[i]);
        }
        list.add(1L);
        Object[] array = list.toArray();
        return array;
    }

    public static String filterDataState(Table table, String sql) {
        if (sql.contains("where")) {
            if (table.hasColumnLabel("datastate")) {
                sql = sql + " and datastate = ?";
            }
        } else if (table.hasColumnLabel("datastate")) {
            sql = sql + " where datastate = ?";
        }
        return sql;
    }

    public static void listFiles(File file, List<File> sqlXmlFiles) throws IOException {
        if (file.getName().endsWith(".sql.xml")) {
            sqlXmlFiles.add(file);
        } else if (file.isDirectory()) {
            File[] subFiles;
            for (File subFile : subFiles = file.listFiles()) {
                SqlKit.listFiles(subFile, sqlXmlFiles);
            }
        }
    }

    private static void getResourceInJar() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = null;
        try {
            resources = resolver.getResources("classpath*:com/domeke/core/model/*.sql.xml");
            Object e = null;
            FileOutputStream os = null;
            InputStream inputStream = null;
            File file = null;
            String path = PathKit.getRootClassPath();
            for (Resource resource : resources) {
                file = new File(path + File.separator + resource.getFilename());
                os = new FileOutputStream(file);
                inputStream = resource.getInputStream();
                FileCopyUtils.copy((InputStream)inputStream, (OutputStream)os);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    static {
        String badStr = "'|and|exec|execute|insert|select|delete|update|count|drop|*|%|chr|mid|master|truncate|char|declare|sitename|net user|xp_cmdshell|;|or|-|+|,|like'|and|exec|execute|insert|create|drop|table|from|grant|use|group_concat|column_name|information_schema.columns|table_schema|union|where|select|delete|update|order|by|count|*|chr|mid|master|truncate|char|declare|or|;|-|--|+|,|like|//|/|%|#";
        badKeyWordList.addAll(Arrays.asList(badStr.split("\\|")));
    }
}

