/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.kit;

import com.domeke.core.kit.Reflect;
import com.google.common.collect.Lists;
import com.jfinal.kit.PathKit;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassSearcher {
    protected static final Logger LOG = LoggerFactory.getLogger(ClassSearcher.class);
    private String classpath = PathKit.getRootClassPath();
    private boolean includeAllJarsInLib = false;
    private List<String> includeJars = Lists.newArrayList();
    private String libDir = PathKit.getWebRootPath() + File.separator + "WEB-INF" + File.separator + "lib";
    private Class target;

    private static <T> List<Class<? extends T>> extraction(Class<T> clazz, List<String> classFileList) {
        ArrayList classList = Lists.newArrayList();
        for (String classFile : classFileList) {
            Class classInFile = (Class)Reflect.on(classFile).get();
            if (!clazz.isAssignableFrom(classInFile) || clazz == classInFile) continue;
            classList.add(classInFile);
        }
        return classList;
    }

    public static ClassSearcher of(Class target) {
        return new ClassSearcher(target);
    }

    private static List<String> findFiles(String baseDirName, String targetFileName) {
        ArrayList classFiles = Lists.newArrayList();
        String tempName = null;
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            LOG.error("search error\uff1a" + baseDirName + "is not a dir\uff01");
        } else {
            String[] filelist = baseDir.list();
            for (int i = 0; i < filelist.length; ++i) {
                File readfile = new File(baseDirName + File.separator + filelist[i]);
                if (readfile.isDirectory()) {
                    classFiles.addAll(ClassSearcher.findFiles(baseDirName + File.separator + filelist[i], targetFileName));
                    continue;
                }
                tempName = readfile.getName();
                if (!ClassSearcher.wildcardMatch(targetFileName, tempName)) continue;
                String tem = readfile.getAbsoluteFile().toString().replaceAll("\\\\", "/");
                String classname = tem.substring(tem.indexOf("/classes") + "/classes".length() + 1, tem.indexOf(".class"));
                classFiles.add(classname.replaceAll("/", "."));
            }
        }
        return classFiles;
    }

    private static boolean wildcardMatch(String pattern, String str) {
        int patternLength = pattern.length();
        int strLength = str.length();
        int strIndex = 0;
        for (int patternIndex = 0; patternIndex < patternLength; ++patternIndex) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (ClassSearcher.wildcardMatch(pattern.substring(patternIndex + 1), str.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
                continue;
            }
            if (ch == '?') {
                if (++strIndex <= strLength) continue;
                return false;
            }
            if (strIndex >= strLength || ch != str.charAt(strIndex)) {
                return false;
            }
            ++strIndex;
        }
        return strIndex == strLength;
    }

    public ClassSearcher(Class target) {
        this.target = target;
    }

    public ClassSearcher injars(List<String> jars) {
        if (jars != null) {
            this.includeJars.addAll(jars);
        }
        return this;
    }

    public ClassSearcher inJars(String ... jars) {
        if (jars != null) {
            for (String jar : jars) {
                this.includeJars.add(jar);
            }
        }
        return this;
    }

    public ClassSearcher classpath(String classpath) {
        this.classpath = classpath;
        return this;
    }

    public <T> List<Class<? extends T>> search() {
        List<String> classFileList = ClassSearcher.findFiles(this.classpath, "*.class");
        classFileList.addAll(this.findjarFiles(this.libDir, this.includeJars));
        return ClassSearcher.extraction(this.target, classFileList);
    }

    private List<String> findjarFiles(String baseDirName, final List<String> includeJars) {
        ArrayList classFiles = Lists.newArrayList();
        try {
            File baseDir = new File(baseDirName);
            if (!baseDir.exists() || !baseDir.isDirectory()) {
                LOG.error("file serach error\uff1a" + baseDirName + " is not a dir\uff01");
            } else {
                String[] filelist = baseDir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return ClassSearcher.this.includeAllJarsInLib || includeJars.contains(name);
                    }
                });
                for (int i = 0; i < filelist.length; ++i) {
                    JarFile localJarFile = new JarFile(new File(baseDirName + File.separator + filelist[i]));
                    Enumeration<JarEntry> entries = localJarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        String entryName = jarEntry.getName();
                        if (jarEntry.isDirectory() || !entryName.endsWith(".class")) continue;
                        String className = entryName.replaceAll("/", ".").substring(0, entryName.length() - 6);
                        classFiles.add(className);
                    }
                    localJarFile.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classFiles;
    }

    public ClassSearcher includeAllJarsInLib(boolean includeAllJarsInLib) {
        this.includeAllJarsInLib = includeAllJarsInLib;
        return this;
    }

    public ClassSearcher libDir(String libDir) {
        this.libDir = libDir;
        return this;
    }
}

