/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.kit;

import java.security.Key;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class EncryptionKit {
    public static final String KEY_ALGORITHM = "IDEA";
    public static final String CIPHER_ALGORITHM = "IDEA/ECB/PKCS5Padding";

    public static String md5Encrypt(String srcStr) {
        return EncryptionKit.encrypt("MD5", srcStr);
    }

    public static String sha1Encrypt(String srcStr) {
        return EncryptionKit.encrypt("SHA-1", srcStr);
    }

    public static String sha256Encrypt(String srcStr) {
        return EncryptionKit.encrypt("SHA-256", srcStr);
    }

    public static String sha384Encrypt(String srcStr) {
        return EncryptionKit.encrypt("SHA-384", srcStr);
    }

    public static String sha512Encrypt(String srcStr) {
        return EncryptionKit.encrypt("SHA-512", srcStr);
    }

    public static String encrypt(String algorithm, String srcStr) {
        try {
            byte[] bytes;
            StringBuilder result = new StringBuilder();
            MessageDigest md = MessageDigest.getInstance(algorithm);
            for (byte b : bytes = md.digest(srcStr.getBytes("utf-8"))) {
                String hex = Integer.toHexString(b & 0xFF);
                if (hex.length() == 1) {
                    result.append("0");
                }
                result.append(hex);
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Key toKey(byte[] key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, KEY_ALGORITHM);
        return secretKey;
    }

    public static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        Key k = EncryptionKit.toKey(key);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, k);
        return cipher.doFinal(data);
    }

    public static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        Key k = EncryptionKit.toKey(key);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, k);
        return cipher.doFinal(data);
    }

    public static byte[] initKey() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        kg.init(128);
        SecretKey secretKey = kg.generateKey();
        return secretKey.getEncoded();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

