/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.kit;

import com.domeke.core.kit.DruidKit;
import com.google.common.collect.Lists;
import com.jfinal.plugin.druid.DruidPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitDatabaseKit {
    private static Logger logger = LoggerFactory.getLogger(InitDatabaseKit.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute(List<String> sqlList) {
        DruidPlugin druidPlugin = DruidKit.getDruidPlugin();
        druidPlugin.start();
        DataSource dataSource = druidPlugin.getDataSource();
        Connection connection = null;
        Statement pst = null;
        ResultSet rs = null;
        try {
            connection = dataSource.getConnection();
            connection.setAutoCommit(false);
            pst = connection.createStatement();
            for (String sql : sqlList) {
                pst.addBatch(sql);
            }
            pst.executeBatch();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                InitDatabaseKit.dbClose(connection, pst, rs);
                throw throwable;
            }
            InitDatabaseKit.dbClose(connection, pst, rs);
        }
        InitDatabaseKit.dbClose(connection, pst, rs);
    }

    private static void dbClose(Connection conn, Statement pst, ResultSet rs) {
        try {
            if (conn != null) {
                conn.close();
            }
            if (pst != null) {
                conn.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static List<String> readSqlScript(String path) throws Exception {
        ArrayList list = Lists.newArrayList();
        File fileDir = new File(path);
        if (fileDir.isDirectory()) {
            File[] files = fileDir.listFiles();
            ArrayList fileList = Lists.newArrayList();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().endsWith(".sql")) continue;
                fileList.add(files[i]);
            }
            Collections.sort(fileList, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    if (o1.isDirectory() && o2.isFile()) {
                        return -1;
                    }
                    if (o1.isFile() && o2.isDirectory()) {
                        return 1;
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (File sqlScript : fileList) {
                if (sqlScript.isDirectory()) {
                    InitDatabaseKit.readSqlScript(sqlScript.getAbsolutePath());
                    continue;
                }
                FileInputStream sqlFileIn = null;
                try {
                    sqlFileIn = new FileInputStream(sqlScript);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                StringBuffer sqlSb = new StringBuffer();
                byte[] buff = new byte[1024];
                int byteRead = 0;
                while ((byteRead = ((InputStream)sqlFileIn).read(buff)) != -1) {
                    sqlSb.append(new String(buff, 0, byteRead));
                }
                String[] sqlArr = sqlSb.toString().split(";");
                for (int i = 0; i < sqlArr.length; ++i) {
                    String sql = sqlArr[i];
                    if ((sql = sql.replaceAll("--.*", "").trim()).equals("")) continue;
                    list.add(sql);
                    logger.info("====start=== \n");
                    logger.info(sql + "\n");
                    logger.info("====end=== \n");
                }
            }
        }
        return list;
    }

    public static void main(String[] args) {
        URL classpath = InitDatabaseKit.class.getClass().getResource("/");
        String path = classpath.getPath().substring(0, classpath.getPath().lastIndexOf("/") - 14);
        path = path + "init-db-mysql";
        System.out.println(path);
        try {
            List<String> sqlScript = InitDatabaseKit.readSqlScript(path);
            InitDatabaseKit.execute(sqlScript);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

