/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.kit;

import com.domeke.core.solr.SolrServerClient;
import com.google.common.collect.Lists;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.Page;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrKit<T> {
    private static volatile SolrKit<?> solrKit;
    private static Logger logger;
    private boolean isSetFacet = false;

    private SolrKit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> SolrKit<T> getInstance() {
        if (solrKit != null) return solrKit;
        Class<SolrKit> clazz = SolrKit.class;
        synchronized (SolrKit.class) {
            if (solrKit != null) return solrKit;
            solrKit = new SolrKit<T>();
            // ** MonitorExit[var0] (shouldn't be in output)
            return solrKit;
        }
    }

    public static <T> Page<T> query(String[] tags, String queryKey, Class<T> c, Page<T> page, String[] queryFilter) throws SolrServerException {
        SolrKit<T> solrKit = SolrKit.getInstance();
        return super.querys(tags, queryKey, c, page, queryFilter);
    }

    private Page<T> querys(String[] tags, String queryKey, Class<T> c, Page<T> page, String[] queryFilter) throws SolrServerException {
        SolrQuery query = this.setQueryFilter(page, tags, queryKey, queryFilter);
        if (query == null) {
            return null;
        }
        QueryResponse response = null;
        try {
            HttpSolrServer server = SolrServerClient.getInstance().getServer();
            response = server.query((SolrParams)query);
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        SolrDocumentList docs = response.getResults();
        List<T> voList = this.getBaseVoList(c, docs);
        page = this.getPage(page, docs, voList);
        logger.info("=======\u6587\u6863\u4e2a\u6570\uff1a{}", (Object)docs.getNumFound());
        logger.info("=======\u67e5\u8be2\u65f6\u95f4\uff1a{}", (Object)response.getQTime());
        return page;
    }

    private Page<T> getPage(Page<T> page, SolrDocumentList docs, List<T> voList) {
        int numFound = (int)docs.getNumFound();
        int totalPageSize = 1;
        totalPageSize = numFound % page.getPageSize() != 0 ? numFound / page.getPageSize() + 1 : numFound / page.getPageSize();
        page = new Page<T>(voList, page.getPageNumber(), page.getPageSize(), totalPageSize, numFound);
        return page;
    }

    private List<T> getBaseVoList(Class<T> c, SolrDocumentList docs) {
        ArrayList voList = Lists.newArrayList();
        for (SolrDocument doc : docs) {
            T t = this.newModel(c);
            if (t == null) break;
            Collection fieldNames = doc.getFieldNames();
            for (String fieldName : fieldNames) {
                Object fieldValue = doc.getFieldValue(fieldName);
                logger.debug("{}====== {}", (Object)fieldName, doc.getFieldValue(fieldName));
                try {
                    BeanUtils.setProperty(t, (String)fieldName, (Object)fieldValue);
                }
                catch (IllegalAccessException e) {
                    logger.error("IllegalAccessException", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    logger.error("InvocationTargetException", (Throwable)e);
                }
            }
            voList.add(t);
        }
        return voList;
    }

    private T newModel(Class<T> c) {
        try {
            T t = c.newInstance();
            return t;
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    private SolrQuery setQueryFilter(Page<T> page, String[] tags, String queryKey, String[] queryFilter) {
        if (tags == null || tags.length <= 0) {
            return null;
        }
        SolrQuery query = new SolrQuery();
        this.setQuery(query, tags, queryKey);
        this.setHighlight(query, tags);
        if (this.isSetFacet) {
            this.setFacet(query, tags);
        }
        if (queryFilter != null && queryFilter.length > 0) {
            query.addFilterQuery(queryFilter);
        }
        this.setPage(query, page);
        this.setSort(query, tags);
        query.setTimeAllowed(Integer.valueOf(1000));
        return query;
    }

    private void setPage(SolrQuery query, Page<T> page) {
        int pageNumber = page.getPageNumber();
        int pageSize = page.getPageSize();
        query.setStart(Integer.valueOf((pageNumber - 1) * pageSize));
        query.setRows(Integer.valueOf(pageSize));
    }

    private void setSort(SolrQuery query, String[] tags) {
        for (String tag : tags) {
            query.addSort(tag, SolrQuery.ORDER.desc);
        }
    }

    private void setQuery(SolrQuery query, String[] tags, String queryKey) {
        StringBuffer queryStrBuffer = new StringBuffer();
        if (StrKit.isBlank(queryKey)) {
            queryKey = "";
        }
        for (int i = 0; i < tags.length; ++i) {
            queryStrBuffer.append(tags[i] + ":" + queryKey);
            if (i == tags.length - 1) continue;
            queryStrBuffer.append(" OR ");
        }
        logger.info("queryStrBuffer:===========" + queryStrBuffer.toString());
        query.setQuery(queryStrBuffer.toString());
    }

    private void setHighlight(SolrQuery query, String[] tags) {
        query.setHighlight(true);
        for (String tag : tags) {
            query.addHighlightField(tag);
        }
        query.setHighlightSimplePre("<font color='red'>");
        query.setHighlightSimplePost("</font>");
        query.setHighlightSnippets(tags.length);
        query.setHighlightFragsize(1000);
    }

    private void setFacet(SolrQuery query, String[] tags) {
        query.setFacet(true);
        query.setFacetMinCount(1);
        query.setFacetLimit(tags.length);
        query.addFacetField(tags);
    }

    public boolean isSetFacet() {
        return this.isSetFacet;
    }

    public void setSetFacet(boolean isSetFacet) {
        this.isSetFacet = isSetFacet;
    }

    public static void main(String[] args) {
        String test = "test:123,test:123,";
        String result = test.substring(0, test.length() - 1);
        System.out.println(result);
    }

    static {
        logger = LoggerFactory.getLogger(SolrKit.class);
    }
}

