/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.kit;

import com.domeke.core.kit.PropsKit;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoKit {
    private static Logger logger = LoggerFactory.getLogger(VideoKit.class);
    private static String FFMEPG_PATH;
    public static int COMMOND_VIDEO;
    public static int COMMOND_IMAGE;
    private static String toDirectory;

    public static boolean checkVideoType(String filepath) {
        int pathLen;
        int fileSuffixIndex = filepath.lastIndexOf(".");
        String type = filepath.substring(fileSuffixIndex + 1, pathLen = filepath.length()).toLowerCase();
        if (type.equals("avi")) {
            return true;
        }
        if (type.equals("mpg")) {
            return true;
        }
        if (type.equals("wmv")) {
            return true;
        }
        if (type.equals("3gp")) {
            return true;
        }
        if (type.equals("mov")) {
            return true;
        }
        if (type.equals("mp4")) {
            return true;
        }
        if (type.equals("asf")) {
            return true;
        }
        if (type.equals("asx")) {
            return true;
        }
        return type.equals("flv");
    }

    public static boolean checkFile(String filepath) {
        File file = new File(filepath);
        return file.isFile();
    }

    public static String getVideoPath(File file) {
        String filepath = file.getAbsolutePath();
        int filePrefixIndex = filepath.lastIndexOf(".");
        String filePathAndName = "";
        if (toDirectory == null || toDirectory.length() == 0) {
            filePathAndName = filepath.substring(0, filePrefixIndex + 1);
        } else {
            File toCatalogueFile = new File(toDirectory);
            if (!toCatalogueFile.exists()) {
                toCatalogueFile.mkdirs();
            }
            int fileNameIndex = filepath.lastIndexOf("\\");
            filePathAndName = filepath.substring(fileNameIndex + 1, filePrefixIndex + 1);
        }
        filePathAndName = toDirectory + filePathAndName + "mp4";
        return filePathAndName;
    }

    public static String getImagePath(File file) {
        String filepath = file.getAbsolutePath();
        int filePrefixIndex = filepath.lastIndexOf(".");
        String filePathAndName = "";
        if (toDirectory == null || toDirectory.length() == 0) {
            filePathAndName = filepath.substring(0, filePrefixIndex + 1);
        } else {
            File toCatalogueFile = new File(toDirectory);
            if (!toCatalogueFile.exists()) {
                toCatalogueFile.mkdir();
            }
            int fileNameIndex = filepath.lastIndexOf("\\");
            filePathAndName = filepath.substring(fileNameIndex + 1, filePrefixIndex + 1);
        }
        filePathAndName = toDirectory + filePathAndName + "png";
        return filePathAndName;
    }

    public static String compressVideo(File file, String toDirectory) {
        VideoKit.toDirectory = toDirectory;
        String targePath = VideoKit.process(file, COMMOND_VIDEO);
        VideoKit.process(file, COMMOND_IMAGE);
        return targePath;
    }

    private static Map<String, Object> buildCompressCommand(File file) {
        HashMap resultMap = Maps.newHashMap();
        ArrayList command = Lists.newArrayList();
        String videoPath = VideoKit.getVideoPath(file);
        command.add(FFMEPG_PATH);
        command.add("-i");
        command.add(file.getAbsolutePath());
        command.add(" --acodec libfaac");
        command.add(" --ab 128k");
        command.add(" -ac 2");
        command.add(" -vcodec libx264");
        command.add(" -ar 22050");
        command.add(" -crf 22");
        command.add(" -r 30");
        command.add(" -threads 0 ");
        command.add(" -qscale 6");
        command.add(" -y ");
        command.add(videoPath);
        logger.info("\u89c6\u9891\u8f6c\u6362==={}", (Object)videoPath);
        resultMap.put("command", command);
        resultMap.put("targetPath", videoPath);
        return resultMap;
    }

    private static Map<String, Object> buildImageCommond(File file) {
        HashMap resultMap = Maps.newHashMap();
        ArrayList command = Lists.newArrayList();
        String imagePath = VideoKit.getImagePath(file);
        command.add(FFMEPG_PATH);
        command.add("-i");
        command.add(file.getAbsolutePath());
        command.add("-y");
        command.add("-f");
        command.add("image2");
        command.add("-ss");
        command.add("30");
        command.add("-t");
        command.add("0.001");
        command.add("-s");
        command.add("350*240");
        command.add(imagePath);
        logger.info("\u89c6\u9891\u622a\u56fe==={}", (Object)imagePath);
        resultMap.put("command", command);
        resultMap.put("targetPath", imagePath);
        return resultMap;
    }

    public static String process(File file, int commType) {
        Map<Object, Object> resultMap = Maps.newHashMap();
        List<String> command = Lists.newArrayList();
        resultMap = COMMOND_IMAGE == commType ? VideoKit.buildImageCommond(file) : VideoKit.buildCompressCommand(file);
        command = (List)resultMap.get("command");
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            logger.info("*********************\u89c6\u9891\u538b\u7f29 start **************************");
            StringBuffer infoBuffer = new StringBuffer();
            for (String comm : command) {
                infoBuffer.append(comm + " ");
            }
            logger.info("\u89c6\u9891\u538b\u7f29\u547d\u4ee4{}", (Object)infoBuffer.toString());
            builder.command(command);
            builder.redirectErrorStream(true);
            builder.start();
            logger.info("*********************\u89c6\u9891\u538b\u7f29 end **************************");
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362\u89c6\u9891\u5931\u8d25", (Throwable)e);
        }
        return (String)resultMap.get("targetPath");
    }

    public static void main(String[] args) {
        VideoKit.compressVideo(new File("G:\\1.mp4"), "G:\\upload\\");
    }

    static {
        COMMOND_VIDEO = 0;
        COMMOND_IMAGE = 1;
        toDirectory = "";
        FFMEPG_PATH = PropsKit.getString("ffmepgPath");
    }
}

