/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.kit;

import com.domeke.core.kit.CodeKit;
import com.domeke.core.kit.EncryptionKit;
import com.domeke.core.kit.PropsKit;
import com.domeke.core.model.Operator;
import com.domeke.core.model.User;
import com.domeke.core.plugin.PropertiesPlugin;
import com.jfinal.ext.kit.DateTimeKit;
import com.jfinal.kit.StrKit;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebKit {
    private static Logger logger = LoggerFactory.getLogger(WebKit.class);

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getContextPath(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append(request.getContextPath());
        String path = sb.toString();
        sb = null;
        return path;
    }

    public static String getRequestURIWithParam(HttpServletRequest request) {
        return request.getRequestURI() + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
    }

    public static Map<String, String> getParamMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration enume = request.getParameterNames();
        while (enume.hasMoreElements()) {
            String name = (String)enume.nextElement();
            map.put(name, request.getParameter(name));
        }
        return map;
    }

    public static void addCookie(HttpServletResponse response, String domain, String path, boolean isHttpOnly, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        if (null != domain && !domain.isEmpty()) {
            cookie.setDomain(domain);
        }
        cookie.setPath("/");
        if (null != path && !path.isEmpty()) {
            cookie.setPath(path);
        }
        cookie.setHttpOnly(isHttpOnly);
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        response.addCookie(cookie);
    }

    public static String getCookieValueByName(HttpServletRequest request, String name) {
        Map<String, Cookie> cookieMap = WebKit.readCookieMap(request);
        if (cookieMap.containsKey(name)) {
            Cookie cookie = cookieMap.get(name);
            return cookie.getValue();
        }
        return null;
    }

    public static Cookie getCookieByName(HttpServletRequest request, String name) {
        Map<String, Cookie> cookieMap = WebKit.readCookieMap(request);
        if (cookieMap.containsKey(name)) {
            Cookie cookie = cookieMap.get(name);
            return cookie;
        }
        return null;
    }

    public static Map<String, Cookie> readCookieMap(HttpServletRequest request) {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (int i = 0; i < cookies.length; ++i) {
                cookieMap.put(cookies[i].getName(), cookies[i]);
            }
        }
        return cookieMap;
    }

    public static String HtmltoText(String inputString) {
        String htmlStr = inputString;
        String textStr = "";
        try {
            String regEx_script = "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
            String regEx_style = "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?style[\\s]*?>";
            String regEx_html = "<[^>]+>";
            String patternStr = "\\s+";
            Pattern p_script = Pattern.compile(regEx_script, 2);
            Matcher m_script = p_script.matcher(htmlStr);
            htmlStr = m_script.replaceAll("");
            Pattern p_style = Pattern.compile(regEx_style, 2);
            Matcher m_style = p_style.matcher(htmlStr);
            htmlStr = m_style.replaceAll("");
            Pattern p_html = Pattern.compile(regEx_html, 2);
            Matcher m_html = p_html.matcher(htmlStr);
            htmlStr = m_html.replaceAll("");
            Pattern p_ba = Pattern.compile(patternStr, 2);
            Matcher m_ba = p_ba.matcher(htmlStr);
            textStr = htmlStr = m_ba.replaceAll("");
        }
        catch (Exception e) {
            System.err.println("Html2Text: " + e.getMessage());
        }
        return textStr;
    }

    public static String getHTMLToString(String sourcestr) {
        if (sourcestr == null) {
            return "";
        }
        sourcestr = sourcestr.replaceAll("\\x26", "&amp;");
        sourcestr = sourcestr.replaceAll("\\x3c", "&lt;");
        sourcestr = sourcestr.replaceAll("\\x3e", "&gt;");
        sourcestr = sourcestr.replaceAll("\\x09", "&nbsp;&nbsp;&nbsp;&nbsp;");
        sourcestr = sourcestr.replaceAll("\\x20", "&nbsp;");
        sourcestr = sourcestr.replaceAll("\\x22", "&quot;");
        sourcestr = sourcestr.replaceAll("\r\n", "<br>");
        sourcestr = sourcestr.replaceAll("\r", "<br>");
        sourcestr = sourcestr.replaceAll("\n", "<br>");
        return sourcestr;
    }

    public static User getCurrentUser(HttpServletRequest request, boolean userAgentVali) {
        String loginCookie = WebKit.getCookieValueByName(request, "authmark");
        logger.info("loginCookie === {}", (Object)loginCookie);
        if (null != loginCookie && !loginCookie.equals("")) {
            try {
                loginCookie = StrKit.decode(loginCookie);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            byte[] securityByte = Base64.decodeBase64((String)loginCookie);
            String securityKey = PropsKit.getString("config.securityKey");
            byte[] keyByte = Base64.decodeBase64((String)securityKey);
            byte[] dataByte = null;
            try {
                dataByte = EncryptionKit.decrypt(securityByte, keyByte);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String data = new String(dataByte);
            String[] datas = data.split(".#.");
            long loginDateTimes = Long.parseLong(datas[0]);
            String userIds = datas[1];
            String ips = datas[2];
            String userAgent = datas[3];
            String newIp = WebKit.getIpAddr(request);
            String newUserAgent = request.getHeader("User-Agent");
            Date start = DateTimeKit.getDate();
            start.setTime(loginDateTimes);
            int day = DateTimeKit.getDateDaySpace(start, DateTimeKit.getDate());
            logger.info(" \u9a8c\u8bc1ip========{}, ===== {}", (Object)ips, (Object)newIp);
            logger.info(" \u9a8c\u8bc1userAgentVali========{}, ===== {}", (Object)userAgent, (Object)newUserAgent);
            logger.info(" \u9a8c\u8bc1day========{}", (Object)day);
            if (ips.equals(newIp) && (!userAgentVali || userAgent.equals(newUserAgent)) && day <= 365) {
                logger.info(" \u9a8c\u8bc1\u6570\u636e\u6709\u6548\u6027 userIds {}", (Object)userIds);
                User userObj = CodeKit.getUser(userIds);
                if (null != userObj) {
                    User user = userObj;
                    return user;
                }
            }
        }
        logger.info(" \u9a8c\u8bc1\u6570\u636e\u6709\u6548\u6027 user \u4e3a\u7a7a !!!!");
        return null;
    }

    public static void setCurrentUser(HttpServletRequest request, HttpServletResponse response, User user, boolean autoLogin) {
        int maxAgeTemp = -1;
        if (autoLogin) {
            maxAgeTemp = PropsKit.getInt("config.maxAge");
        }
        WebKit.addCookie(response, "", "/", true, "userName", user.getStr("username"), maxAgeTemp);
        String userIds = user.getPKValue();
        String ips = WebKit.getIpAddr(request);
        String userAgent = request.getHeader("User-Agent");
        long date = DateTimeKit.getDateTime();
        StringBuilder token = new StringBuilder();
        token.append(date).append(".#.").append(userIds).append(".#.").append(ips).append(".#.").append(userAgent);
        String authToken = token.toString();
        byte[] authTokenByte = null;
        try {
            authTokenByte = authToken.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String securityKey = (String)PropertiesPlugin.getParamMapValue("config.securityKey");
        byte[] keyByte = Base64.decodeBase64((String)securityKey);
        byte[] securityByte = null;
        try {
            securityByte = EncryptionKit.encrypt(authTokenByte, keyByte);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String securityCookie = Base64.encodeBase64String((byte[])securityByte);
        try {
            securityCookie = StrKit.encode(securityCookie);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WebKit.addCookie(response, "", "/", true, "authmark", securityCookie, maxAgeTemp);
    }

    public static boolean hasPrivilegeOperator(Operator operator, User user) {
        String operatorIds = operator.getPKValue() + ",";
        String userOperator = User.dao.getUserOperator(user);
        return userOperator.indexOf(operatorIds) != -1;
    }
}

