/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.model;

import com.domeke.core.db.sql.SqlKit;
import com.domeke.core.kit.CommonKit;
import com.google.common.collect.Maps;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseModel<M extends Model<M>>
extends Model<M> {
    private static final long serialVersionUID = -900378319414539856L;
    private static Logger log = LoggerFactory.getLogger(BaseModel.class);

    protected String getSql(String sqlId) {
        return SqlKit.getSql(sqlId);
    }

    protected String getSql(String sqlId, Map<String, Object> param) {
        return SqlKit.getSql(sqlId, param);
    }

    protected String getSql(String sqlId, Map<String, String> param, LinkedList<Object> list) {
        return SqlKit.getSql(sqlId, param, list);
    }

    protected Table getTable() {
        return TableMapping.me().getTable(this.getClass());
    }

    public String getPKValue() {
        return this.getStr(this.getTable().getPrimaryKey()[0]);
    }

    @Override
    public boolean save() {
        this.set(this.getTable().getPrimaryKey()[0], CommonKit.getUuidByJdk(true));
        if (this.getTable().hasColumnLabel("version")) {
            this.set("version", 0L);
        }
        if (this.getTable().hasColumnLabel("create_time")) {
            this.set("create_time", this.getCurrentTime());
        }
        if (this.getTable().hasColumnLabel("modify_time")) {
            this.set("modify_time", this.getCurrentTime());
        }
        if (this.getTable().hasColumnLabel("datastate")) {
            this.set("datastate", 1L);
        }
        return super.save();
    }

    public Timestamp getCurrentTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = sdf.format(new Date());
        Timestamp nowTime = Timestamp.valueOf(time);
        return nowTime;
    }

    @Override
    public boolean update() {
        Table table = this.getTable();
        boolean hasVersion = table.hasColumnLabel("version");
        if (hasVersion) {
            String name = table.getName();
            String pk = table.getPrimaryKey()[0];
            HashMap param = Maps.newHashMap();
            param.put("table", name);
            param.put("pk", pk);
            String sql = SqlKit.getSql("domeke.core.baseModel.version", param);
            Object modelOld = this.findFirst(sql, this.getPKValue());
            if (null == modelOld) {
                throw new RuntimeException("\u6570\u636e\u5e93\u4e2d\u6b64\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u540e\u5728\u64cd\u4f5c");
            }
            Set modifyFlag = null;
            try {
                Field field = this.getClass().getSuperclass().getSuperclass().getDeclaredField("modifyFlag");
                field.setAccessible(true);
                Object object = field.get(this);
                if (null != object) {
                    modifyFlag = (Set)object;
                }
                field.setAccessible(false);
            }
            catch (NoSuchFieldException | SecurityException e) {
                log.error("\u4e1a\u52a1Model\u7c7b\u5fc5\u987b\u7ee7\u627fBaseModel");
                e.printStackTrace();
                throw new RuntimeException("\u4e1a\u52a1Model\u7c7b\u5fc5\u987b\u7ee7\u627fBaseModel");
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error("BaseModel\u8bbf\u95eemodifyFlag\u5f02\u5e38");
                e.printStackTrace();
                throw new RuntimeException("BaseModel\u8bbf\u95eemodifyFlag\u5f02\u5e38");
            }
            boolean versionModify = modifyFlag.contains("version");
            if (versionModify) {
                Long versionDB = ((Model)modelOld).getNumber("version").longValue();
                Long versionForm = this.getNumber("version").longValue() + 1L;
                if (versionForm <= versionDB) {
                    throw new RuntimeException("\u8868\u5355\u6570\u636e\u7248\u672c\u53f7\u548c\u6570\u636e\u5e93\u6570\u636e\u7248\u672c\u53f7\u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u6570\u636e\u5df2\u7ecf\u88ab\u5176\u4ed6\u4eba\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91");
                }
            }
            if (this.getTable().hasColumnLabel("modify_time")) {
                this.set("modify_time", this.getCurrentTime());
            }
        }
        return super.update();
    }

    @Override
    public boolean delete() {
        Table table = this.getTable();
        boolean isDelEnable = table.hasColumnLabel("datastate");
        return super.delete();
    }

    @Override
    public boolean deleteById(Object id) {
        Table table = this.getTable();
        boolean isDelEnable = table.hasColumnLabel("datastate");
        return super.deleteById(id);
    }

    @Override
    public List<M> find(String sql, Object ... paras) {
        Table table = this.getTable();
        Object[] array = paras;
        if (table.hasColumnLabel("datastate")) {
            // empty if block
        }
        return super.find(sql, array);
    }

    public boolean isNotEmpty() {
        Object[] attrValues = this.getAttrValues();
        return attrValues.length > 0;
    }

    public boolean isEmpty() {
        return this.isNotEmpty();
    }
}

