/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.plugin;

import com.jfinal.plugin.IPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18NPlugin
implements IPlugin {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Map<String, Map<String, String>> resourceBundleMap = new HashMap<String, Map<String, String>>();

    public static String i18n(String i18n) {
        String val = "_zhcn";
        if (i18n.equals("zh") || i18n.equals("zh_cn")) {
            val = "_zhcn";
        } else if (i18n.equals("en") || i18n.equals("en_us")) {
            val = "_enus";
        } else if (i18n.equals("ja") || i18n.equals("ja_jp")) {
            val = "_ja";
        } else if (i18n.equals("zh_hk")) {
            val = "_zhhk";
        } else if (i18n.equals("zh_tw")) {
            val = "_zhtw";
        }
        return val;
    }

    public static Map<String, String> get(String localePramKey) {
        Map<String, String> map = resourceBundleMap.get(localePramKey = localePramKey.equals("zh") ? "zh_cn" : (localePramKey.equals("en") ? "en_us" : "zh_cn"));
        if (map != null) {
            return map;
        }
        return resourceBundleMap.get("zh_cn");
    }

    public static String get(String i18n, String key) {
        Map<String, String> map = I18NPlugin.get(i18n);
        return map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start() {
        String[] languages = new String[]{"zh_CN", "zh_HK", "zh_TW", "en_US", "ja"};
        String fileName = null;
        for (String language : languages) {
            fileName = "/message_" + language + ".properties";
            InputStream inputStream = null;
            try {
                inputStream = I18NPlugin.class.getResourceAsStream(fileName);
                Properties properties = new Properties();
                properties.load(inputStream);
                this.log.debug("\u52a0\u8f7d\u56fd\u9645\u5316\u8d44\u6e90\u6587\u4ef6\uff1a" + fileName);
                HashMap<String, String> i18nMap = new HashMap<String, String>();
                Enumeration<Object> keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = properties.getProperty(key);
                    i18nMap.put(key, value);
                }
                resourceBundleMap.put(language.toLowerCase(), i18nMap);
            }
            catch (Exception exception) {
                this.log.info("\u52a0\u8f7dproperties\u5931\u8d25\uff01...");
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    this.log.info("\u52a0\u8f7dproperties\u540e\u5173\u95ed\u5931\u8d25\uff01...");
                }
            }
        }
        return true;
    }

    @Override
    public boolean stop() {
        resourceBundleMap.clear();
        return true;
    }
}

