/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.plugin;

import com.google.common.collect.Maps;
import com.jfinal.kit.PropKit;
import com.jfinal.plugin.IPlugin;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesPlugin
implements IPlugin {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static Map<String, Object> paramMap = Maps.newHashMap();
    private Properties properties;

    public PropertiesPlugin(Properties properties) {
        this.properties = properties;
    }

    public static Object getParamMapValue(String key) {
        return paramMap.get(key);
    }

    @Override
    public boolean start() {
        paramMap.put("solr_admin_url", this.properties.getProperty("solr_admin_url"));
        paramMap.put("db.type", this.properties.getProperty("db.type").trim());
        String db_type = (String)PropertiesPlugin.getParamMapValue("db.type");
        if (db_type.equals("postgresql")) {
            this.initPostgreDBProperties();
        } else if (db_type.equals("mysql")) {
            this.initMySqlDBProperties();
        } else {
            this.initOracleDBProperties();
        }
        paramMap.put("db.initialSize", this.properties.getProperty("db.initialSize"));
        paramMap.put("db.minIdle", this.properties.getProperty("db.minIdle"));
        paramMap.put("db.maxActive", this.properties.getProperty("db.maxActive"));
        paramMap.put("db.maxWait", this.properties.getProperty("db.maxWait"));
        paramMap.put("db.timeBetweenEvictionRunsMillis", this.properties.getProperty("db.timeBetweenEvictionRunsMillis"));
        paramMap.put("db.minEvictableIdleTimeMillis", this.properties.getProperty("db.minEvictableIdleTimeMillis"));
        paramMap.put("db.testWhileIdle", this.properties.getProperty("db.testWhileIdle"));
        paramMap.put("db.testOnBorrow", this.properties.getProperty("db.testOnBorrow"));
        paramMap.put("db.testOnReturn", this.properties.getProperty("db.testOnReturn"));
        paramMap.put("db.removeAbandoned", this.properties.getProperty("db.removeAbandoned"));
        paramMap.put("db.removeAbandonedTimeoutMillis", this.properties.getProperty("db.removeAbandonedTimeoutMillis"));
        paramMap.put("db.jdbc.stat", this.properties.getProperty("db.jdbc.stat"));
        Properties properties = PropKit.use("domeke.properties", "UTF-8").getProperties();
        String scan_package = properties.getProperty("config.scan.package").trim();
        if (null != scan_package && !scan_package.isEmpty()) {
            String[] pkgs;
            ArrayList<String> list = new ArrayList<String>();
            for (String pkg : pkgs = scan_package.split(",")) {
                list.add(pkg.trim());
            }
            paramMap.put("config.scan.package", list);
        } else {
            paramMap.put("config.scan.package", new ArrayList());
        }
        String scan_jar = properties.getProperty("config.scan.jar").trim();
        if (null != scan_jar && !scan_jar.isEmpty()) {
            String[] jars;
            ArrayList<String> list = new ArrayList<String>();
            for (String jar : jars = scan_jar.split(",")) {
                list.add(jar.trim());
            }
            paramMap.put("config.scan.jar", list);
        } else {
            paramMap.put("config.scan.jar", new ArrayList());
        }
        paramMap.put("config.devMode", properties.getProperty("config.devMode").trim());
        paramMap.put("config.luceneIndex", properties.getProperty("config.luceneIndex").trim());
        paramMap.put("config.securityKey", properties.getProperty("config.securityKey").trim());
        paramMap.put("config.passErrorCount", Integer.valueOf(properties.getProperty("config.passErrorCount")));
        paramMap.put("config.passErrorHour", Integer.valueOf(properties.getProperty("config.passErrorHour")));
        paramMap.put("config.maxPostSize", Integer.valueOf(properties.getProperty("config.maxPostSize")));
        paramMap.put("config.maxAge", Integer.valueOf(properties.getProperty("config.maxAge")));
        paramMap.put("config.domain", properties.getProperty("config.domain"));
        paramMap.put("config.mail.host", properties.getProperty("config.mail.host").trim());
        paramMap.put("config.mail.port", properties.getProperty("config.mail.port").trim());
        paramMap.put("config.mail.from", properties.getProperty("config.mail.from").trim());
        paramMap.put("config.mail.userName", properties.getProperty("config.mail.userName").trim());
        paramMap.put("config.mail.password", properties.getProperty("config.mail.password").trim());
        paramMap.put("config.mail.to", properties.getProperty("config.mail.to").trim());
        paramMap.put("upload_file_path", properties.getProperty("upload_file_path").trim());
        for (String key : paramMap.keySet()) {
            this.log.debug("\u5168\u5c40\u53c2\u6570\u914d\u7f6e\uff1a" + key + " = " + paramMap.get(key));
        }
        return true;
    }

    private void initMySqlDBProperties() {
        paramMap.put("jdbc.driverClass", "com.mysql.jdbc.Driver");
        paramMap.put("jdbc.url", this.properties.getProperty("mysql.jdbc.url").trim());
        paramMap.put("jdbc.username", this.properties.getProperty("mysql.jdbc.username").trim());
        paramMap.put("jdbc.password", this.properties.getProperty("mysql.jdbc.password").trim());
        paramMap.put("mysql.db.validationQuery", this.properties.getProperty("mysql.db.validationQuery"));
        String jdbcUrl = (String)PropertiesPlugin.getParamMapValue("jdbc.url");
        String database = jdbcUrl.substring(jdbcUrl.indexOf("//") + 2);
        database = database.substring(database.indexOf("/") + 1);
        String ip = jdbcUrl.substring(jdbcUrl.indexOf("//") + 2);
        ip = ip.substring(0, ip.indexOf(":"));
        String port = jdbcUrl.substring(jdbcUrl.indexOf("//") + 2);
        port = port.substring(port.indexOf(":") + 1, port.indexOf("/"));
        paramMap.put("db_ip", ip);
        paramMap.put("db_port", port);
        paramMap.put("db_name", database);
    }

    private void initPostgreDBProperties() {
        paramMap.put("jdbc.driverClass", this.properties.getProperty("postgresql.jdbc.driverClass").trim());
        paramMap.put("jdbc.url", this.properties.getProperty("postgresql.jdbc.url").trim());
        paramMap.put("jdbc.username", this.properties.getProperty("postgresql.jdbc.username").trim());
        paramMap.put("jdbc.password", this.properties.getProperty("postgresql.jdbc.password").trim());
        String jdbcUrl = (String)PropertiesPlugin.getParamMapValue("jdbc.url");
        String database = jdbcUrl.substring(jdbcUrl.indexOf("//") + 2);
        database = database.substring(database.indexOf("/") + 1);
        String ip = jdbcUrl.substring(jdbcUrl.indexOf("//") + 2);
        ip = ip.substring(0, ip.indexOf(":"));
        String port = jdbcUrl.substring(jdbcUrl.indexOf("//") + 2);
        port = port.substring(port.indexOf(":") + 1, port.indexOf("/"));
        paramMap.put("db_ip", ip);
        paramMap.put("db_port", port);
        paramMap.put("db_name", database);
    }

    private void initOracleDBProperties() {
        paramMap.put("jdbc.driverClass", this.properties.getProperty("oracle.jdbc.driverClass").trim());
        paramMap.put("jdbc.url", this.properties.getProperty("oracle.jdbc.url").trim());
        paramMap.put("jdbc.username", this.properties.getProperty("oracle.jdbc.username").trim());
        paramMap.put("jdbc.password", this.properties.getProperty("oracle.jdbc.password").trim());
        paramMap.put("db.validationQuery", this.properties.getProperty("oracle.db.validationQuery"));
    }

    @Override
    public boolean stop() {
        paramMap.clear();
        return true;
    }

    public static Map<String, Object> getParamMap() {
        return paramMap;
    }
}

